/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.contribution.openidconnect;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.UserManagerAuthenticationRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OpenIdConnectUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OpenIdConnectUserManagerAutenticationRepositoryManager
extends UserManagerAuthenticationRepositoryManager
implements IRepositoryManager {
    private static final String KEY = "OPENIDC_FILE";
    private static final String USERS_PROPERTIES_CONFIG_PROPERTIES_FILE = "users.properties";

    protected String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        Map authenticationData = repositoryData.getAuthenticationData();
        String userManagerConfigurationFilePath = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + "usermanager-config.properties";
        String userPropertiesFile = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + USERS_PROPERTIES_CONFIG_PROPERTIES_FILE;
        try {
            Map usersProperties = CDORepositoryUtil.convertCredentialsToProperties((List)((ArrayList)authenticationData.get("users")));
            CommonUtil.createProperiesFileFromMap((String)userPropertiesFile, (Map)usersProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The users properties file (%1$s) has not been created", USERS_PROPERTIES_CONFIG_PROPERTIES_FILE), (Throwable)e);
        }
        LinkedHashMap<String, String> usermanagerProperties = new LinkedHashMap<String, String>();
        usermanagerProperties.put("users.file.path", userPropertiesFile);
        usermanagerProperties.putAll(OpenIdConnectUtil.addOpenIdConnectPropertiesToMap(authenticationData, false));
        try {
            CommonUtil.createProperiesFileFromMap((String)userManagerConfigurationFilePath, usermanagerProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The users manager properties file (%1$s) has not been created", USERS_PROPERTIES_CONFIG_PROPERTIES_FILE), (Throwable)e);
        }
        String technicalUserPropertiesFile = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + "technicalUsers.properties";
        try {
            LinkedHashMap technicalUsersProperties = new LinkedHashMap();
            CommonUtil.createProperiesFileFromMap((String)technicalUserPropertiesFile, technicalUsersProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The technical users properties file (%1$s) has not been created", "technicalUsers.properties"), (Throwable)e);
        }
        return userManagerConfigurationFilePath;
    }

    public String getKey() {
        return KEY;
    }

    public String validateData(Map<String, Object> data) {
        String validatedData;
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        String validatedOpenIdConnectAuthenticationData = OpenIdConnectUtil.validateOpenIdConnectAuthenticationData(data);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validatedOpenIdConnectAuthenticationData)) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)validatedOpenIdConnectAuthenticationData);
        }
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validatedData = super.validateData(data))) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)validatedData);
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    protected String validateUser(Map<String, Object> user) {
        String detectedIssues = "NO_ISSUE_DIAGNOSTIC";
        Object login = user.get("login");
        if (!(login instanceof String)) {
            detectedIssues = "At least one user login is invalid.";
        } else if (StringUtil.isEmpty((String)login.toString())) {
            detectedIssues = "At least one user login is empty.";
        }
        return detectedIssues;
    }

    public String validateNewUser(NewUser newUser, String repositoryName) {
        return "NO_ISSUE_DIAGNOSTIC";
    }
}

