/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.signal;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OpenIdConnectUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import java.net.URL;
import java.util.Optional;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.PluginRepositoryProvider;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class GetOpenIDAuthenticationInfoIndication
extends IndicationWithResponse {
    private String repositoryName;

    public GetOpenIDAuthenticationInfoIndication(SignalProtocol<?> protocol) {
        super(protocol, (short)202);
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        this.repositoryName = in.readString();
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        String overriddenCommonUrl;
        IRepository repository = PluginRepositoryProvider.INSTANCE.getRepository(this.repositoryName);
        if (repository == null) {
            throw new IllegalArgumentException("The repository " + this.repositoryName + " does not exist");
        }
        Optional<OpenIDAuthenticator> openIDAuthenticator = OpenIdConnectUtil.getOpenIdAuthenticator(repository);
        out.writeBoolean(openIDAuthenticator.isPresent());
        String string = overriddenCommonUrl = openIDAuthenticator.isPresent() ? openIDAuthenticator.get().getConfig().getWebServerURL() : null;
        if (overriddenCommonUrl != null && !overriddenCommonUrl.isEmpty()) {
            URL url = new URL(overriddenCommonUrl);
            out.writeBoolean("https".equals(url.getProtocol()));
            out.writeInt(url.getPort());
        } else {
            AdminServerConfigurationHelper adminServerConfigurationHelper = AdminServerConfigurationHelper.getInstance();
            boolean httpsEnabled = adminServerConfigurationHelper.isHttpsEnabled();
            int port = httpsEnabled ? adminServerConfigurationHelper.getHttpsPort() : adminServerConfigurationHelper.getHttpPort();
            out.writeBoolean(httpsEnabled);
            out.writeInt(port);
        }
    }
}

