/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.lock;

import java.util.Arrays;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchAdjustable;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public final class CDOLockChangeInfoImpl
implements CDOLockChangeInfo,
CDOBranchAdjustable {
    private CDOBranchPoint branchPoint;
    private final CDOLockChangeInfo.Operation operation;
    private final IRWLockManager.LockType lockType;
    private final CDOLockOwner lockOwner;
    private final CDOLockState[] lockStates;
    private final boolean isInvalidateAll;

    public CDOLockChangeInfoImpl(CDOBranchPoint branchPoint, CDOLockOwner lockOwner, CDOLockState[] lockStates, CDOLockChangeInfo.Operation operation, IRWLockManager.LockType lockType) {
        this.branchPoint = branchPoint;
        this.lockOwner = lockOwner;
        this.lockStates = lockStates;
        this.operation = operation;
        this.lockType = lockType;
        this.isInvalidateAll = false;
    }

    public CDOLockChangeInfoImpl() {
        this.lockOwner = null;
        this.lockStates = null;
        this.operation = null;
        this.lockType = null;
        this.isInvalidateAll = true;
    }

    public void adjustBranches(CDOBranchManager newBranchManager) {
        CDOBranch branch;
        if (this.branchPoint != null && (branch = this.branchPoint.getBranch()) != null) {
            branch = newBranchManager.getBranch(branch.getID());
            this.branchPoint = branch.getPoint(this.branchPoint.getTimeStamp());
        }
    }

    public CDOBranch getBranch() {
        return this.branchPoint == null ? null : this.branchPoint.getBranch();
    }

    public long getTimeStamp() {
        return this.branchPoint == null ? 0L : this.branchPoint.getTimeStamp();
    }

    public CDOLockChangeInfo.Operation getOperation() {
        return this.operation;
    }

    public IRWLockManager.LockType getLockType() {
        return this.lockType;
    }

    public CDOLockOwner getLockOwner() {
        return this.lockOwner;
    }

    public CDOLockState[] getLockStates() {
        return this.lockStates;
    }

    public boolean isInvalidateAll() {
        return this.isInvalidateAll;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CDOLockChangeInfo[branchPoint=");
        builder.append(this.branchPoint);
        builder.append(", operation=");
        builder.append((Object)this.operation);
        builder.append(", lockType=");
        builder.append(this.lockType);
        builder.append(", lockOwner=");
        builder.append(this.lockOwner);
        builder.append(", lockStates=");
        builder.append(Arrays.toString(this.lockStates));
        builder.append(", invalidateAll=");
        builder.append(this.isInvalidateAll);
        builder.append("]");
        return builder.toString();
    }
}

