/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.spi.net4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.internal.net4j.TransportConfig;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.ITransportConfig;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.protocol.IProtocolProvider;
import org.eclipse.net4j.protocol.ProtocolVersionException;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.factory.FactoryKey;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.spi.net4j.Channel;
import org.eclipse.spi.net4j.InternalChannel;
import org.eclipse.spi.net4j.InternalChannelMultiplexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChannelMultiplexer
extends Container<IChannel>
implements InternalChannelMultiplexer {
    private static final ThreadLocal<Boolean> INVERSE_CLOSING = new ThreadLocal();
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_CONNECTOR, ChannelMultiplexer.class);
    private ITransportConfig config;
    private long openChannelTimeout = -1L;
    private ConcurrentMap<Short, IChannel> channels = new ConcurrentHashMap<Short, IChannel>();
    @ReflectUtil.ExcludeFromDump
    private transient Set<Short> channelIDs = new HashSet<Short>();
    @ReflectUtil.ExcludeFromDump
    private transient int lastChannelID;

    @Override
    public synchronized ITransportConfig getConfig() {
        if (this.config == null) {
            this.config = new TransportConfig((ILifecycle)this);
        }
        return this.config;
    }

    @Override
    public synchronized void setConfig(ITransportConfig config) {
        this.checkInactive();
        this.config = Net4jUtil.copyTransportConfig((ILifecycle)this, config);
    }

    @Override
    public long getOpenChannelTimeout() {
        if (this.openChannelTimeout == -1L) {
            return OM.BUNDLE.getDebugSupport().getDebugOption("open.channel.timeout", 10000);
        }
        return this.openChannelTimeout;
    }

    @Override
    public void setOpenChannelTimeout(long openChannelTimeout) {
        this.openChannelTimeout = openChannelTimeout;
    }

    public final InternalChannel getChannel(short channelID) {
        return (InternalChannel)this.channels.get(channelID);
    }

    @Override
    public final Collection<IChannel> getChannels() {
        return this.channels.values();
    }

    public boolean isEmpty() {
        return this.channels.isEmpty();
    }

    public IChannel[] getElements() {
        ArrayList<IChannel> list = new ArrayList<IChannel>(this.getChannels());
        return list.toArray(new IChannel[list.size()]);
    }

    @Override
    public InternalChannel openChannel() throws ChannelException {
        return this.openChannel((IProtocol)null);
    }

    @Override
    public InternalChannel openChannel(String protocolID, Object infraStructure) throws ChannelException {
        IProtocol<Object> protocol = this.createProtocol(protocolID, infraStructure);
        if (protocol == null) {
            throw new IllegalArgumentException("Unknown protocolID: " + protocolID);
        }
        return this.openChannel((IProtocol)protocol);
    }

    @Override
    public InternalChannel openChannel(IProtocol<?> protocol) throws ChannelException {
        long start = System.currentTimeMillis();
        this.doBeforeOpenChannel(protocol);
        InternalChannel channel = this.createChannel();
        this.initChannel(channel, protocol);
        short channelID = this.getNextChannelID();
        channel.setID(channelID);
        this.addChannel(channel);
        try {
            try {
                long timeout = this.getOpenChannelTimeout() - System.currentTimeMillis() + start;
                if (timeout <= 0L) {
                    throw new TimeoutRuntimeException();
                }
                this.registerChannelWithPeer(channelID, timeout, protocol);
            }
            catch (TimeoutRuntimeException ex) {
                String message = "Channel registration timeout after " + this.getOpenChannelTimeout() + " milliseconds";
                throw new TimeoutRuntimeException(message, (Throwable)ex);
            }
        }
        catch (ChannelException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ChannelException(ex);
        }
        return channel;
    }

    @Deprecated
    public InternalChannel inverseOpenChannel(short channelID, String protocolID) {
        return this.inverseOpenChannel(channelID, protocolID, 0);
    }

    public InternalChannel inverseOpenChannel(short channelID, String protocolID, int protocolVersion) {
        CONTEXT_MULTIPLEXER.set(this);
        try {
            IProtocol<Object> protocol = this.createProtocol(protocolID, null);
            ProtocolVersionException.checkVersion(protocol, protocolVersion);
            InternalChannel channel = this.createChannel();
            this.initChannel(channel, protocol);
            channel.setID(channelID);
            this.addChannel(channel);
            InternalChannel internalChannel = channel;
            return internalChannel;
        }
        finally {
            CONTEXT_MULTIPLEXER.remove();
        }
    }

    @Override
    public void closeChannel(InternalChannel channel) throws ChannelException {
        InternalChannel internalChannel = channel;
        if (INVERSE_CLOSING.get() == null) {
            this.deregisterChannelFromPeer(internalChannel);
        }
        this.removeChannel(internalChannel);
    }

    public void inverseCloseChannel(short channelID) throws ChannelException {
        InternalChannel channel = this.getChannel(channelID);
        INVERSE_CLOSING.set(Boolean.TRUE);
        try {
            LifecycleUtil.deactivate((Object)channel);
        }
        finally {
            INVERSE_CLOSING.remove();
        }
    }

    @Override
    public void inverseClose() {
        INVERSE_CLOSING.set(Boolean.TRUE);
        try {
            LifecycleUtil.deactivateNoisy((Object)this);
        }
        finally {
            INVERSE_CLOSING.remove();
        }
    }

    protected InternalChannel createChannel() {
        return new Channel();
    }

    protected void initChannel(InternalChannel channel, IProtocol<?> protocol) {
        channel.setMultiplexer(this);
        channel.setReceiveExecutor(this.getConfig().getReceiveExecutor());
        if (protocol != null) {
            protocol.setChannel(channel);
            LifecycleUtil.activate(protocol);
            if (TRACER.isEnabled()) {
                String protocolType = protocol.getType();
                TRACER.format("Opening channel with protocol {0}", new Object[]{protocolType});
            }
            channel.setReceiveHandler(protocol);
        } else if (TRACER.isEnabled()) {
            TRACER.trace("Opening channel without protocol");
        }
    }

    protected <INFRA_STRUCTURE> IProtocol<INFRA_STRUCTURE> createProtocol(String type, INFRA_STRUCTURE infraStructure) {
        if (StringUtil.isEmpty((String)type)) {
            return null;
        }
        IProtocolProvider protocolProvider = this.getConfig().getProtocolProvider();
        if (protocolProvider == null) {
            throw new ChannelException("No protocol provider configured");
        }
        IProtocol<?> protocol = protocolProvider.getProtocol(type);
        if (protocol == null) {
            throw new ChannelException("Invalid protocol factory: " + type);
        }
        if (infraStructure != null) {
            protocol.setInfraStructure(infraStructure);
        }
        return protocol;
    }

    protected IFactoryKey createProtocolFactoryKey(String type) {
        switch (this.getLocation()) {
            case SERVER: {
                return new FactoryKey("org.eclipse.net4j.serverProtocols", type);
            }
            case CLIENT: {
                return new FactoryKey("org.eclipse.net4j.clientProtocols", type);
            }
        }
        throw new IllegalStateException();
    }

    protected void doBeforeOpenChannel(IProtocol<?> protocol) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeactivate() throws Exception {
        IChannel[] channels;
        Set<Short> set = this.channelIDs;
        synchronized (set) {
            channels = this.getElements();
        }
        IChannel[] iChannelArray = channels;
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            IChannel channel = iChannelArray[n2];
            LifecycleUtil.deactivate((Object)channel);
            ++n2;
        }
        set = this.channelIDs;
        synchronized (set) {
            this.channels.clear();
        }
        super.doDeactivate();
    }

    protected abstract INegotiationContext createNegotiationContext();

    protected abstract void registerChannelWithPeer(short var1, long var2, IProtocol<?> var4) throws ChannelException;

    protected abstract void deregisterChannelFromPeer(InternalChannel var1) throws ChannelException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getNextChannelID() {
        Set<Short> set = this.channelIDs;
        synchronized (set) {
            short id;
            int start = this.lastChannelID;
            int maxValue = Short.MAX_VALUE;
            do {
                ++this.lastChannelID;
                if (this.lastChannelID == start) {
                    throw new ChannelException("Too many channels");
                }
                if (this.lastChannelID <= maxValue) continue;
                this.lastChannelID = 1;
            } while (!this.channelIDs.add(id = (short)(this.isClient() ? this.lastChannelID : -this.lastChannelID)));
            return id;
        }
    }

    private void addChannel(InternalChannel channel) {
        short channelID = channel.getID();
        if (channelID == 0 || channelID == Short.MIN_VALUE) {
            throw new ChannelException("Invalid channel ID: " + channelID);
        }
        this.channels.put(channelID, channel);
        LifecycleUtil.activate((Object)channel);
        this.fireElementAddedEvent(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChannel(InternalChannel channel) {
        try {
            boolean removed;
            short channelID = channel.getID();
            Set<Short> set = this.channelIDs;
            synchronized (set) {
                boolean bl = removed = this.channels.remove(channelID) != null;
                if (removed) {
                    this.channelIDs.remove(channelID);
                }
            }
            if (removed) {
                this.fireElementRemovedEvent(channel);
            }
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
            throw ex;
        }
    }
}

