/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBAnnotation;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class AbstractTypeMapping
implements ITypeMapping {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractTypeMapping.class);
    private IMappingStrategy mappingStrategy;
    private EStructuralFeature feature;
    private DBType dbType;
    private IDBField field;

    public final IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public final void setMappingStrategy(IMappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    public final EStructuralFeature getFeature() {
        return this.feature;
    }

    public final void setFeature(EStructuralFeature feature) {
        this.feature = feature;
    }

    public final void setDBType(DBType dbType) {
        this.dbType = dbType;
    }

    public DBType getDBType() {
        return this.dbType;
    }

    public final void setValueFromRevision(PreparedStatement stmt, int index, InternalCDORevision revision) throws SQLException {
        this.setValue(stmt, index, this.getRevisionValue(revision));
    }

    public final void setDefaultValue(PreparedStatement stmt, int index) throws SQLException {
        this.setValue(stmt, index, this.getDefaultValue());
    }

    public final void setValue(PreparedStatement stmt, int index, Object value) throws SQLException {
        if (value == CDORevisionData.NIL) {
            if (TRACER.isEnabled()) {
                TRACER.format("TypeMapping for {0}: converting Revision.NIL to DB-null", new Object[]{this.feature.getName()});
            }
            stmt.setNull(index, this.getSqlType());
        } else if (value == null) {
            if (this.feature.isMany() || this.getDefaultValue() == null) {
                if (TRACER.isEnabled()) {
                    TRACER.format("TypeMapping for {0}: writing Revision.null as DB.null", new Object[]{this.feature.getName()});
                }
                stmt.setNull(index, this.getSqlType());
            } else {
                if (TRACER.isEnabled()) {
                    TRACER.format("TypeMapping for {0}: converting Revision.null to default value", new Object[]{this.feature.getName()});
                }
                this.setDefaultValue(stmt, index);
            }
        } else {
            this.doSetValue(stmt, index, value);
        }
    }

    @Deprecated
    public final void createDBField(IDBTable table) {
        this.createDBField(table, this.mappingStrategy.getFieldName(this.feature));
    }

    public final void createDBField(IDBTable table, String fieldName) {
        DBType fieldType = this.getDBType();
        int fieldLength = this.getDBLength(fieldType);
        this.field = table.addField(fieldName, fieldType, fieldLength);
    }

    public final IDBField getField() {
        return this.field;
    }

    public final void setDBField(IDBTable table, String fieldName) {
        this.field = table.getFieldSafe(fieldName);
    }

    public final void readValueToRevision(ResultSet resultSet, InternalCDORevision revision) throws SQLException {
        Object value = this.readValue(resultSet);
        revision.setValue(this.getFeature(), value);
    }

    public final Object readValue(ResultSet resultSet) throws SQLException {
        Object value = this.getResultSetValue(resultSet);
        if (resultSet.wasNull()) {
            if (this.feature.isMany()) {
                if (TRACER.isEnabled()) {
                    TRACER.format("TypeMapping for {0}: read db.null - setting Revision.null", new Object[]{this.feature.getName()});
                }
                value = null;
            } else if (this.getDefaultValue() == null) {
                if (TRACER.isEnabled()) {
                    TRACER.format("TypeMapping for {0}: read db.null - setting Revision.null, because of default", new Object[]{this.feature.getName()});
                }
                value = null;
            } else {
                if (TRACER.isEnabled()) {
                    TRACER.format("TypeMapping for {0}: read db.null - setting Revision.NIL", new Object[]{this.feature.getName()});
                }
                value = CDORevisionData.NIL;
            }
        }
        return value;
    }

    public String toString() {
        IDBField mappedElement = this.field != null ? this.field : this.dbType;
        return MessageFormat.format("{0}[{1}.{2} --> {3}]", this.getClass().getSimpleName(), this.feature.getEContainingClass().getName(), this.feature.getName(), mappedElement);
    }

    protected Object getDefaultValue() {
        return this.feature.getDefaultValue();
    }

    protected final Object getRevisionValue(InternalCDORevision revision) {
        return revision.getValue(this.getFeature());
    }

    protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
        stmt.setObject(index, value, this.getSqlType());
    }

    protected int getSqlType() {
        return this.getDBType().getCode();
    }

    protected int getDBLength(DBType type) {
        String value = DBAnnotation.COLUMN_LENGTH.getValue((EModelElement)this.feature);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                OM.LOG.error("Illegal columnLength annotation of feature " + this.feature.getName());
            }
        }
        IDBAdapter adapter = this.mappingStrategy.getStore().getDBAdapter();
        return adapter.getFieldLength(type);
    }

    protected abstract Object getResultSetValue(ResultSet var1) throws SQLException;
}

