/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.internal.server;

import com.thalesgroup.mde.melody.collab.internal.server.MelodyCollabServerApplication;
import com.thalesgroup.mde.melody.collab.internal.server.OM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.CDOServerExporter;
import org.eclipse.emf.cdo.server.CDOServerImporter;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class CDOCommandProvider
implements CommandProvider {
    public static final String NEW_LINE = System.lineSeparator();
    private static final String AIRD = ".aird";
    private static final String INDENT = "  ";
    private static final String RESULT_OK = "SUCCESS";
    private static final String RESULT_ERROR = "FAILURE";

    public CDOCommandProvider(BundleContext bundleContext) {
        Hashtable<String, Integer> dict = new Hashtable<String, Integer>();
        ((Dictionary)dict).put("service.ranking", 1);
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, dict);
        this.fixCommandProviderAdapterRegistration(bundleContext);
    }

    private void fixCommandProviderAdapterRegistration(BundleContext bundleContext) {
        ServiceReference[] serviceReferences = new ServiceReference[]{};
        String message = "CDO Command Provider has not been properly deployed.";
        try {
            serviceReferences = bundleContext.getServiceReferences(Object.class.getName(), "(osgi.command.function=cdo)");
        }
        catch (InvalidSyntaxException e) {
            Status logStatus = new Status(4, OM.Activator.getBundleContext().getBundle().getSymbolicName(), message, (Throwable)e);
            Platform.getLog((Bundle)OM.Activator.getBundleContext().getBundle()).log((IStatus)logStatus);
        }
        String equinoxConsoleBundle = "org.eclipse.equinox.console";
        String commandProviderAdapterClassName = "org.eclipse.equinox.console.command.adapter.CommandProviderAdapter";
        String commandProviderField = "commandProvider";
        String osgiCommandScope = "osgi.command.scope";
        String osgiCommandFunction = "osgi.command.function";
        ServiceReference[] serviceReferenceArray = serviceReferences;
        int n = serviceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                ServiceReference ref = serviceReferenceArray[n2];
                if ("org.eclipse.equinox.console".equals(ref.getBundle().getSymbolicName())) {
                    Object service = bundleContext.getService(ref);
                    try {
                        try {
                            if ("org.eclipse.equinox.console.command.adapter.CommandProviderAdapter".equals(service.getClass().getName())) {
                                Field field = service.getClass().getDeclaredField("commandProvider");
                                field.setAccessible(true);
                                Object object = field.get(service);
                                if (object == this) {
                                    Hashtable<String, Object> props = new Hashtable<String, Object>();
                                    ((Dictionary)props).put("service.ranking", 1);
                                    ((Dictionary)props).put("osgi.command.scope", ref.getProperty("osgi.command.scope"));
                                    ((Dictionary)props).put("osgi.command.function", ref.getProperty("osgi.command.function"));
                                    bundleContext.registerService(Object.class, service, props);
                                }
                            }
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                            Status logStatus = new Status(4, OM.Activator.getBundleContext().getBundle().getSymbolicName(), message, (Throwable)e);
                            Platform.getLog((Bundle)OM.Activator.getBundleContext().getBundle()).log((IStatus)logStatus);
                            bundleContext.ungetService(ref);
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        bundleContext.ungetService(ref);
                        throw throwable;
                    }
                    bundleContext.ungetService(ref);
                }
            }
            ++n2;
        }
    }

    public String getHelp() {
        StringBuilder help = new StringBuilder();
        help.append(NEW_LINE);
        help.append("---CDO commands---");
        help.append(NEW_LINE);
        help.append("\tcdo list - list all active repositories");
        help.append(NEW_LINE);
        help.append("\tcdo start - start repositories from a config file");
        help.append(NEW_LINE);
        help.append("\tcdo stop - stop a repository");
        help.append(NEW_LINE);
        help.append("\tcdo export - export the contents of a repository to an XML file");
        help.append(NEW_LINE);
        help.append("\tcdo import - import the contents of a repository from an XML file");
        help.append(NEW_LINE);
        help.append("\tcdo sessions - dump the sessions of a repository");
        help.append(NEW_LINE);
        help.append("\tcdo packages - dump the packages of a repository");
        help.append(NEW_LINE);
        help.append("\tcdo branches - dump the branches of a repository");
        help.append(NEW_LINE);
        help.append("\tcdo locks - dump the durable locking areas of a repository");
        help.append(NEW_LINE);
        help.append("\tcdo deletelocks - delete a durable locking area of a repository");
        help.append(NEW_LINE);
        help.append("\tcdo stopserver - stop this server asynchronously without asking for confirmation");
        help.append(NEW_LINE);
        help.append("\tcdo nop - does nothing, can be used to test if the server is alive");
        help.append(NEW_LINE);
        help.append("\tcdo nop \"comment\" - does nothing but will display given comment in the server console");
        help.append(NEW_LINE);
        return help.toString();
    }

    public Object _cdo(CommandInterpreter interpreter) {
        String cmd;
        block28: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block19: {
                                                block18: {
                                                    block17: {
                                                        cmd = interpreter.nextArgument();
                                                        if (!"list".equals(cmd)) break block17;
                                                        this.list(interpreter);
                                                        return null;
                                                    }
                                                    if (!"start".equals(cmd)) break block18;
                                                    this.start(interpreter);
                                                    return null;
                                                }
                                                if (!"stop".equals(cmd)) break block19;
                                                this.stop(interpreter);
                                                return null;
                                            }
                                            if (!"export".equals(cmd)) break block20;
                                            this.exportXML(interpreter);
                                            return null;
                                        }
                                        if (!"import".equals(cmd)) break block21;
                                        this.importXML(interpreter);
                                        return null;
                                    }
                                    if (!"sessions".equals(cmd)) break block22;
                                    this.sessions(interpreter);
                                    return null;
                                }
                                if (!"packages".equals(cmd)) break block23;
                                this.packages(interpreter);
                                return null;
                            }
                            if (!"branches".equals(cmd)) break block24;
                            this.branches(interpreter);
                            return null;
                        }
                        if (!"locks".equals(cmd)) break block25;
                        this.locks(interpreter);
                        return null;
                    }
                    if (!"deletelocks".equals(cmd)) break block26;
                    this.deleteLocks(interpreter);
                    return null;
                }
                if (!"stopserver".equals(cmd)) break block27;
                this.stopServer(interpreter);
                return null;
            }
            if (!"nop".equals(cmd)) break block28;
            this.nop(interpreter);
            return null;
        }
        try {
            if (!this.tryToExecuteOtherCommand(interpreter, cmd)) {
                interpreter.println((Object)this.getHelp());
                interpreter.println((Object)this.getContributedCommandtHelp());
                interpreter.println((Object)RESULT_ERROR);
            } else {
                interpreter.println((Object)RESULT_OK);
            }
        }
        catch (CommandException ex) {
            interpreter.println((Object)ex.getMessage());
        }
        catch (Exception ex) {
            interpreter.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private synchronized Map<String, CDOCommand> getOtherContributedCommands() {
        HashMap<String, CDOCommand> commands = new HashMap<String, CDOCommand>();
        try {
            for (String name : IPluginContainer.INSTANCE.getFactoryTypes("org.eclipse.emf.cdo.server.commands")) {
                try {
                    CDOCommand command = this.createCommand(name);
                    this.addCommand(commands, command);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        return commands;
    }

    private CDOCommand createCommand(String name) {
        return (CDOCommand)IPluginContainer.INSTANCE.getElement("org.eclipse.emf.cdo.server.commands", name, null);
    }

    private void addCommand(Map<String, CDOCommand> commands, CDOCommand command) {
        commands.put(command.getName(), command);
    }

    private boolean tryToExecuteOtherCommand(CommandInterpreter interpreter, String cmd) {
        block6: {
            Map<String, CDOCommand> commands = this.getOtherContributedCommands();
            CDOCommand command = commands.get(cmd);
            if (command == null) break block6;
            try {
                command.setInterpreter(interpreter);
                command.execute();
            }
            catch (Throwable throwable) {
                try {
                    command.setInterpreter(null);
                    throw throwable;
                }
                catch (CommandException ex) {
                    interpreter.println((Object)ex.getMessage());
                    break block6;
                }
                catch (Exception ex) {
                    interpreter.printStackTrace((Throwable)ex);
                }
            }
            command.setInterpreter(null);
            return true;
        }
        return false;
    }

    private String getContributedCommandtHelp() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append("---Other Contributed CDO commands---" + NEW_LINE);
            ArrayList<CDOCommand> commands = new ArrayList<CDOCommand>(this.getOtherContributedCommands().values());
            Collections.sort(commands, (o1, o2) -> o1.getName().compareTo(o2.getName()));
            for (CDOCommand command : commands) {
                try {
                    builder.append("   ");
                    builder.append(command.getSyntax());
                    builder.append(" - ");
                    builder.append(command.getDescription());
                    builder.append(NEW_LINE);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        return builder.toString();
    }

    protected void nop(CommandInterpreter interpreter) {
        final String comment = interpreter.nextArgument();
        if (!comment.isEmpty()) {
            Job printMessageInLocalConsoleJob = new Job("Print Message In Target Console"){

                protected IStatus run(IProgressMonitor paramIProgressMonitor) {
                    Status logStatus = new Status(1, OM.Activator.getBundleContext().getBundle().getSymbolicName(), comment);
                    Platform.getLog((Bundle)OM.Activator.getBundleContext().getBundle()).log((IStatus)logStatus);
                    return Status.OK_STATUS;
                }
            };
            printMessageInLocalConsoleJob.schedule();
            try {
                printMessageInLocalConsoleJob.join();
                interpreter.println((Object)RESULT_OK);
            }
            catch (InterruptedException e) {
                interpreter.println((Object)"An error occured when trying to display a message on the target's console");
            }
        }
    }

    protected void list(CommandInterpreter interpreter) throws Exception {
        IManagedContainer container = MelodyCollabServerApplication.getContainer();
        Object[] objectArray = container.getElements("org.eclipse.emf.cdo.server.repositories");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof InternalRepository) {
                InternalRepository repository = (InternalRepository)element;
                interpreter.println((Object)repository.getName());
            }
            ++n2;
        }
        interpreter.println((Object)RESULT_OK);
    }

    protected void start(CommandInterpreter interpreter) throws Exception {
        String configFile = this.nextArgument(interpreter, "Syntax: cdo start <config-file>");
        IManagedContainer container = MelodyCollabServerApplication.getContainer();
        RepositoryConfigurator repositoryConfigurator = new RepositoryConfigurator(container);
        IRepository[] repositories = repositoryConfigurator.configure(new File(configFile));
        interpreter.println((Object)"Repositories started:");
        if (repositories != null) {
            IRepository[] iRepositoryArray = repositories;
            int n = repositories.length;
            int n2 = 0;
            while (n2 < n) {
                IRepository repository = iRepositoryArray[n2];
                interpreter.println((Object)repository.getName());
                ++n2;
            }
        }
        interpreter.println((Object)RESULT_OK);
    }

    protected void stop(CommandInterpreter interpreter) throws Exception {
        InternalRepository repository = this.getRepository(interpreter, "Syntax: cdo stop <repository-name>");
        LifecycleUtil.deactivate((Object)repository);
        interpreter.println((Object)"Repository stopped");
        interpreter.println((Object)RESULT_OK);
    }

    protected void exportXML(CommandInterpreter interpreter) throws Exception {
        String syntax = "Syntax: cdo export <repository-name> <export-file>";
        InternalRepository repository = this.getRepository(interpreter, syntax);
        String exportFile = this.nextArgument(interpreter, syntax);
        if (Boolean.getBoolean("com.thalesgroup.mde.collab.internal.server.export.xml.disableAirdsLocking")) {
            this.doExportXML(interpreter, repository, exportFile);
        } else {
            InternalSession session = repository.getSessionManager().openSession(null);
            InternalView view = this.createView(repository, session);
            try {
                boolean lockedAirdSuccess;
                block13: {
                    StoreThreadLocal.setSession((InternalSession)session);
                    lockedAirdSuccess = false;
                    try {
                        lockedAirdSuccess = this.lockAirdResources(view);
                    }
                    catch (InterruptedException e) {
                        interpreter.println((Object)RESULT_ERROR);
                        StoreThreadLocal.release();
                        break block13;
                    }
                    catch (TimeoutRuntimeException e) {
                        try {
                            interpreter.println((Object)("FAILURE TIMEOUT: Timeout while attempting to acquire lock on aird resource: " + e.getMessage()));
                            break block13;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            StoreThreadLocal.release();
                        }
                    }
                    StoreThreadLocal.release();
                }
                if (lockedAirdSuccess) {
                    this.doExportXML(interpreter, repository, exportFile);
                }
            }
            finally {
                this.releaseLocksAndCloseSession(view);
            }
        }
    }

    private void doExportXML(CommandInterpreter interpreter, InternalRepository repository, String exportFile) throws Exception {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream out = new FileOutputStream(exportFile);){
            CDOServerExporter.XML exporter = new CDOServerExporter.XML((IRepository)repository);
            exporter.exportRepository((OutputStream)out);
            interpreter.println((Object)"Repository exported");
            interpreter.println((Object)RESULT_OK);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void releaseLocksAndCloseSession(InternalView view) {
        InternalLockManager lockingManager = view.getRepository().getLockingManager();
        InternalSession session = view.getSession();
        lockingManager.unlock((Object)view);
        view.close();
        session.close();
    }

    private boolean lockAirdResources(InternalView view) throws InterruptedException {
        InternalRepository repository = view.getRepository();
        CDOID rootResourceID = repository.getRootResourceID();
        CDORevision rootRevision = view.getRevision(rootResourceID);
        Collection<InternalCDORevision> projectRevisions = this.getProjectRevisions(view, (InternalCDORevision)rootRevision);
        ArrayList airdResourceRevisions = new ArrayList();
        projectRevisions.forEach(currentRev -> this.collectRemoteAirdResourceRevision(airdResourceRevisions, view, repository, (InternalCDORevision)currentRev));
        for (InternalCDORevision resource : airdResourceRevisions) {
            this.lock(view, resource);
        }
        return true;
    }

    private void lock(InternalView view, InternalCDORevision resource) throws InterruptedException {
        InternalRepository repository = view.getRepository();
        InternalLockManager lockingManager = repository.getLockingManager();
        try {
            lockingManager.lock(IRWLockManager.LockType.WRITE, (Object)view, (Object)resource.getID(), repository.getOptimisticLockingTimeout());
        }
        catch (TimeoutRuntimeException e) {
            try {
                Object name = resource.getValue((EStructuralFeature)EresourcePackage.eINSTANCE.getCDOResourceNode_Name());
                if (name instanceof String) {
                    throw new TimeoutRuntimeException((String)name, (Throwable)e);
                }
                throw e;
            }
            catch (IllegalArgumentException e2) {
                throw e;
            }
        }
    }

    private InternalView createView(InternalRepository repository, InternalSession session) {
        InternalCDOBranch mainBranch = repository.getBranchManager().getMainBranch();
        InternalView view = session.openView(0, mainBranch.getHead());
        return view;
    }

    private void collectRemoteAirdResourceRevision(Collection<InternalCDORevision> airdResourceRevisions, InternalView view, InternalRepository repository, InternalCDORevision folderRevision) {
        Object values = folderRevision.getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_FOLDER__NODES);
        if (values instanceof CDOList) {
            for (Object potentialResource : (CDOList)values) {
                Object resourceName;
                CDOID potentialResourceId;
                CDORevision potentialResourceRevision;
                if (!(potentialResource instanceof CDOID) || !(potentialResourceRevision = view.getRevision(potentialResourceId = (CDOID)potentialResource)).isResource() || potentialResourceRevision.isResourceFolder() || !(potentialResourceRevision instanceof InternalCDORevision) || !((resourceName = ((InternalCDORevision)potentialResourceRevision).getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME)) instanceof String) || !((String)resourceName).endsWith(AIRD)) continue;
                airdResourceRevisions.add((InternalCDORevision)potentialResourceRevision);
            }
        }
    }

    private Collection<InternalCDORevision> getProjectRevisions(InternalView view, InternalCDORevision repoRevision) {
        ArrayList<InternalCDORevision> potentialProjects = new ArrayList<InternalCDORevision>();
        Object contentRepo = repoRevision.getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__CONTENTS);
        if (contentRepo instanceof CDOList) {
            for (Object firstLevelElt : (CDOList)contentRepo) {
                CDOID firstLevelEltId;
                CDORevision firstLevelEltRevision;
                if (!(firstLevelElt instanceof CDOID) || !((firstLevelEltRevision = view.getRevision(firstLevelEltId = (CDOID)firstLevelElt)) instanceof InternalCDORevision) || !firstLevelEltRevision.isResourceFolder()) continue;
                potentialProjects.add((InternalCDORevision)firstLevelEltRevision);
            }
        }
        return potentialProjects;
    }

    protected void importXML(CommandInterpreter interpreter) throws Exception {
        String syntax = "Syntax: cdo import <repository-name> <import-file>";
        InternalRepository repository = this.getRepository(interpreter, syntax);
        String importFile = this.nextArgument(interpreter, syntax);
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileInputStream in = new FileInputStream(importFile);){
            LifecycleUtil.deactivate((Object)repository);
            CDOServerImporter.XML importer = new CDOServerImporter.XML((IRepository)repository);
            importer.importRepository((InputStream)in);
            IManagedContainer container = MelodyCollabServerApplication.getContainer();
            CDOServerUtil.addRepository((IManagedContainer)container, (IRepository)repository);
            interpreter.println((Object)"Repository imported");
            interpreter.println((Object)RESULT_OK);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void sessions(CommandInterpreter interpreter) {
        InternalRepository repository = this.getRepository(interpreter, "Syntax: cdo sessions <repository-name>");
        InternalSessionManager sessionManager = repository.getSessionManager();
        InternalSession[] sessions = sessionManager.getSessions();
        if (sessions.length > 0) {
            InternalSession[] internalSessionArray = sessionManager.getSessions();
            int n = internalSessionArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalSession session = internalSessionArray[n2];
                interpreter.println((Object)session);
                InternalView[] internalViewArray = session.getViews();
                int n3 = internalViewArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    InternalView view = internalViewArray[n4];
                    interpreter.println((Object)(INDENT + view));
                    ++n4;
                }
                ++n2;
            }
        } else {
            interpreter.println((Object)"There is no opened capella projects");
        }
        interpreter.println((Object)RESULT_OK);
    }

    protected void packages(CommandInterpreter interpreter) {
        InternalRepository repository = this.getRepository(interpreter, "Syntax: cdo packages <repository-name>");
        InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageRegistry.getPackageUnits();
        int n = internalCDOPackageUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            interpreter.println((Object)packageUnit);
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
            int n3 = internalCDOPackageInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n4];
                interpreter.println((Object)(INDENT + packageInfo));
                ++n4;
            }
            ++n2;
        }
        interpreter.println((Object)RESULT_OK);
    }

    protected void branches(CommandInterpreter interpreter) {
        InternalRepository repository = this.getRepository(interpreter, "Syntax: cdo branches <repository-name>");
        this.branches(interpreter, repository.getBranchManager().getMainBranch(), "");
        interpreter.println((Object)RESULT_OK);
    }

    protected void locks(final CommandInterpreter interpreter) {
        final InternalRepository repository = this.getRepository(interpreter, "Syntax: cdo locks <repository-name> [<username-prefix>]");
        final String userIDPrefix = this.nextArgument(interpreter, null);
        new WithAccessor(){

            @Override
            protected void doExecute(IStoreAccessor accessor) {
                repository.getLockingManager().getLockAreas(userIDPrefix, area -> {
                    interpreter.println((Object)area.getDurableLockingID());
                    interpreter.println((Object)("  userID = " + area.getUserID()));
                    interpreter.println((Object)("  branch = " + area.getBranch()));
                    interpreter.println((Object)("  timeStamp = " + CDOCommonUtil.formatTimeStamp((long)area.getTimeStamp())));
                    interpreter.println((Object)("  readOnly = " + area.isReadOnly()));
                    interpreter.println((Object)("  locks = " + area.getLocks()));
                    return true;
                });
            }
        }.execute(repository);
        interpreter.println((Object)RESULT_OK);
    }

    protected void deleteLocks(CommandInterpreter interpreter) {
        String syntax = "Syntax: cdo deletelocks <repository-name> <area-id>";
        final InternalRepository repository = this.getRepository(interpreter, syntax);
        final String durableLockingID = this.nextArgument(interpreter, syntax);
        new WithAccessor(){

            @Override
            protected void doExecute(IStoreAccessor accessor) {
                repository.getLockingManager().deleteLockArea(durableLockingID);
            }
        }.execute(repository);
        interpreter.println((Object)RESULT_OK);
    }

    protected void stopServer(CommandInterpreter interpreter) {
        Job stopServerJob = new Job("Stop Server"){

            protected IStatus run(IProgressMonitor paramIProgressMonitor) {
                try {
                    OM.Activator.getBundleContext().getBundle(0L).stop();
                }
                catch (BundleException e) {
                    Status logStatus = new Status(4, OM.Activator.getBundleContext().getBundle().getSymbolicName(), "Stop server failed", (Throwable)e);
                    Platform.getLog((Bundle)OM.Activator.getBundleContext().getBundle()).log((IStatus)logStatus);
                }
                return Status.OK_STATUS;
            }
        };
        stopServerJob.schedule(1000L);
        interpreter.println((Object)RESULT_OK);
    }

    private void branches(CommandInterpreter interpreter, InternalCDOBranch branch, String prefix) {
        interpreter.println((Object)(String.valueOf(prefix) + branch));
        String extendedPrefix = String.valueOf(prefix) + INDENT;
        InternalCDOBranch[] internalCDOBranchArray = branch.getBranches();
        int n = internalCDOBranchArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOBranch child = internalCDOBranchArray[n2];
            this.branches(interpreter, child, extendedPrefix);
            ++n2;
        }
    }

    private String nextArgument(CommandInterpreter interpreter, String syntax) {
        String argument = interpreter.nextArgument();
        if (argument == null && syntax != null) {
            throw new CommandException(syntax);
        }
        return argument;
    }

    private InternalRepository getRepository(CommandInterpreter interpreter, String syntax) {
        String repositoryName = this.nextArgument(interpreter, syntax);
        InternalRepository repository = this.getRepository(repositoryName);
        if (repository == null) {
            throw new CommandException("Repository not found: " + repositoryName);
        }
        return repository;
    }

    private InternalRepository getRepository(String name) {
        IManagedContainer container = MelodyCollabServerApplication.getContainer();
        Object[] objectArray = container.getElements("org.eclipse.emf.cdo.server.repositories");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalRepository repository;
            Object element = objectArray[n2];
            if (element instanceof InternalRepository && (repository = (InternalRepository)element).getName().equals(name)) {
                return repository;
            }
            ++n2;
        }
        return null;
    }

    private static final class CommandException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CommandException(String message) {
            super(message);
        }
    }

    protected static abstract class WithAccessor {
        protected WithAccessor() {
        }

        public void execute(InternalRepository repository) {
            IStoreAccessor accessor = repository.getStore().getReader(null);
            StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
            try {
                this.doExecute(accessor);
            }
            finally {
                StoreThreadLocal.release();
            }
        }

        protected abstract void doExecute(IStoreAccessor var1);
    }
}

