/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.internal.server;

import com.thalesgroup.mde.melody.collab.adm.server.protocol.RemoteAdminServerProtocol;
import com.thalesgroup.mde.melody.collab.internal.server.MelodyRepositoryConfigurator;
import com.thalesgroup.mde.melody.collab.internal.server.OM;
import com.thalesgroup.mde.melody.collab.server.messages.CollabServerMessages;
import com.thalesgroup.mde.melody.collab.server.repository.IRepositoryExtension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.IAppExtension;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.OSGiApplication;
import org.xml.sax.SAXException;

public class MelodyCollabServerApplication
extends OSGiApplication {
    private static final String COLLAB_CLOSE_SERVER_AFTER_INITIALIZATION = "com.thalesgroup.mde.capella.team.close.server.after.initialization";
    private static final String EXECUTABLE_EXTENSION_CLASS = "class";
    public static final String ID = "org.eclipse.emf.cdo.server.app";
    public static final String PROP_BROWSER_PORT = "org.eclipse.emf.cdo.server.browser.port";
    public static final String PLUGIN_ID = "com.thalesgroup.mde.melody.collab.server";
    protected IRepository[] repositories;
    protected List<IAppExtension> extensions = new ArrayList<IAppExtension>();
    protected IManagedContainer managedContainer;

    public MelodyCollabServerApplication() {
        super(ID);
    }

    protected void doStart() throws Exception {
        super.doStart();
        IManagedContainer container = MelodyCollabServerApplication.getContainer();
        this.addShutdownHook();
        OM.LOG.info(CollabServerMessages.getString("CDOServerApplication.1"));
        File configFile = OMPlatform.INSTANCE.getConfigFile("cdo-server.xml");
        if (configFile != null) {
            if (configFile.exists()) {
                this.doStartRepositories(container, configFile);
            } else {
                OM.LOG.warn(String.valueOf(CollabServerMessages.getString("CDOServerApplication.5")) + configFile.getAbsolutePath());
            }
        }
        OM.LOG.info(CollabServerMessages.getString("CDOServerApplication.6"));
        this.enableJVMConnections(container);
        this.doStartAdminServer();
        if (Boolean.getBoolean(COLLAB_CLOSE_SERVER_AFTER_INITIALIZATION)) {
            Job job = Job.create((String)"Stop the server", monitor -> {
                try {
                    while (!this.isRunning()) {
                    }
                    this.stop();
                }
                catch (Exception e) {
                    OM.LOG.error((Throwable)e);
                }
            });
            job.schedule();
        }
    }

    private void doStartRepositories(IManagedContainer container, File configFile) throws ParserConfigurationException, SAXException, IOException, CoreException {
        String port;
        OM.LOG.info(String.valueOf(CollabServerMessages.getString("CDOServerApplication.9")) + configFile.getAbsolutePath());
        MelodyRepositoryConfigurator repositoryConfigurator = new MelodyRepositoryConfigurator(container);
        IRepository[] iRepositoryArray = this.repositories = repositoryConfigurator.getRepositories(configFile);
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IRepository repository = iRepositoryArray[n2];
            this.prepareRepositoryExtensions(repository, configFile);
            repositoryConfigurator.configure(container, repository);
            ++n2;
        }
        if (this.repositories == null || this.repositories.length == 0) {
            OM.LOG.warn(String.valueOf(CollabServerMessages.getString("CDOServerApplication.3")) + configFile.getAbsolutePath());
        }
        if ((port = OMPlatform.INSTANCE.getProperty(PROP_BROWSER_PORT)) != null) {
            container.getElement("org.eclipse.emf.cdo.server.browsers", "default", port);
        }
        IRepository[] iRepositoryArray2 = this.repositories;
        int n3 = this.repositories.length;
        n = 0;
        while (n < n3) {
            IRepository repository = iRepositoryArray2[n];
            this.startRepositoryExtensions(repository, configFile);
            ++n;
        }
        this.startExtensions(configFile);
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                this.setPriority(1);
                if (MelodyCollabServerApplication.this.managedContainer.isActive()) {
                    OM.LOG.info(CollabServerMessages.getString("CDOServerApplication.2"));
                    try {
                        MelodyCollabServerApplication.this.doStop();
                    }
                    catch (Exception e) {
                        OM.LOG.info(String.valueOf(CollabServerMessages.getString("CDOServerApplication.11")) + e.getMessage());
                    }
                    OM.LOG.info(CollabServerMessages.getString("CDOServerApplication.10"));
                }
            }
        });
    }

    private void enableJVMConnections(IManagedContainer container) {
        JVMUtil.prepareContainer((IManagedContainer)container);
        JVMUtil.getAcceptor((IManagedContainer)container, (String)"default");
    }

    protected void doStartAdminServer() throws Exception {
        this.managedContainer = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)this.managedContainer);
        TCPUtil.prepareContainer((IManagedContainer)this.managedContainer);
        this.managedContainer.registerFactory((IFactory)new RemoteAdminServerProtocol.Factory());
        this.managedContainer.activate();
    }

    protected void doStopAdminServer() {
        LifecycleUtil.deactivate((Object)this.managedContainer);
    }

    protected void doStop() throws Exception {
        OM.LOG.info(CollabServerMessages.getString("CDOServerApplication.7"));
        for (IAppExtension extension : this.extensions) {
            try {
                extension.stop();
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        if (this.repositories != null) {
            IRepository[] iRepositoryArray = this.repositories;
            int n = this.repositories.length;
            int n2 = 0;
            while (n2 < n) {
                IRepository repository = iRepositoryArray[n2];
                LifecycleUtil.deactivate((Object)repository);
                ++n2;
            }
        }
        OM.LOG.info(CollabServerMessages.getString("CDOServerApplication.8"));
        this.doStopAdminServer();
        super.doStop();
    }

    private void startExtensions(File configFile) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server", "appExtensions");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("appExtension".equals(element.getName())) {
                try {
                    IAppExtension extension = (IAppExtension)element.createExecutableExtension(EXECUTABLE_EXTENSION_CLASS);
                    extension.start(configFile);
                    this.extensions.add(extension);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++n2;
        }
    }

    private void prepareRepositoryExtensions(IRepository repository, File configFile) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PLUGIN_ID, "repository");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("repositoryExtension".equals(element.getName())) {
                try {
                    IRepositoryExtension extension = (IRepositoryExtension)element.createExecutableExtension(EXECUTABLE_EXTENSION_CLASS);
                    extension.prepare(repository, configFile);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++n2;
        }
    }

    private void startRepositoryExtensions(IRepository repository, File configFile) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PLUGIN_ID, "repository");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("repositoryExtension".equals(element.getName())) {
                try {
                    IRepositoryExtension extension = (IRepositoryExtension)element.createExecutableExtension(EXECUTABLE_EXTENSION_CLASS);
                    extension.extend(repository, configFile);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++n2;
        }
    }

    public static IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }
}

