/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.server;

import com.thalesgroup.mde.melody.collab.server.repository.db.job.AbstractJob;
import com.thalesgroup.mde.melody.collab.server.repository.db.job.BackupOnceJob;
import com.thalesgroup.mde.melody.collab.server.repository.db.job.JobStatusListener;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;

public class MelodyDbCommandProvider
implements CommandProvider {
    public static final String NEW_LINE = System.lineSeparator();
    private static final String RESULT_OK = "SUCCESS";
    private static final String RESULT_ERROR = "FAILURE";

    public MelodyDbCommandProvider(BundleContext bundleContext) {
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public String getHelp() {
        StringBuilder help = new StringBuilder();
        help.append(NEW_LINE);
        help.append("---Controlling the Team for Capella Server Database commands---" + NEW_LINE);
        help.append("\tcapella_db backup - backup database for all H2 repositories" + NEW_LINE);
        help.append("\tcapella_db backup backup_folder_path - backup database for all H2 repositories in the specified backup folder path" + NEW_LINE);
        return help.toString();
    }

    public Object _capella_db(CommandInterpreter interpreter) {
        block8: {
            String cmd;
            block7: {
                block6: {
                    cmd = interpreter.nextArgument();
                    if (!"backup".equals(cmd)) break block6;
                    this.backup(interpreter);
                    return null;
                }
                if (!"success".equals(cmd)) break block7;
                interpreter.println((Object)RESULT_OK);
                return null;
            }
            if (!"failed".equals(cmd) && !"pascal".equals(cmd)) break block8;
            interpreter.println((Object)RESULT_ERROR);
            return null;
        }
        try {
            interpreter.println((Object)this.getHelp());
        }
        catch (CommandException ex) {
            interpreter.println((Object)ex.getMessage());
            interpreter.println((Object)RESULT_ERROR);
        }
        catch (Exception ex) {
            interpreter.printStackTrace((Throwable)ex);
            interpreter.println((Object)RESULT_ERROR);
        }
        return null;
    }

    protected void backup(CommandInterpreter interpreter) throws Exception {
        interpreter.println((Object)"Backup process started");
        String backupFolder = interpreter.nextArgument();
        if (backupFolder == null || backupFolder.isEmpty()) {
            backupFolder = System.getProperty("collab.db.backupFolder");
        }
        String result = RESULT_OK;
        for (IRepository repository : this.getAllRepositories()) {
            IStore store = repository.getStore();
            if (!(store instanceof DBStore)) continue;
            BackupOnceJob backup = new BackupOnceJob((DBStore)store, backupFolder);
            CommandInterpreterUpdateJob updateInterpreter = new CommandInterpreterUpdateJob(backup, interpreter);
            JobStatusListener statusListener = new JobStatusListener(backup);
            backup.schedule();
            backup.join();
            IStatus status = statusListener.getStatus();
            if (status.getMessage() != null) {
                interpreter.println((Object)status.getMessage());
            }
            if (status.getException() != null) {
                interpreter.println((Object)status.getMessage());
            }
            if (status.isOK()) continue;
            result = RESULT_ERROR;
        }
        interpreter.println((Object)result);
    }

    private Set<IRepository> getAllRepositories() {
        IPluginContainer container = IPluginContainer.INSTANCE;
        Set repositories = Arrays.asList(container.getElements("org.eclipse.emf.cdo.server.repositories")).stream().filter(IRepository.class::isInstance).map(IRepository.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
        return repositories;
    }

    private static final class CommandException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CommandException(String message) {
            super(message);
        }
    }

    private class CommandInterpreterUpdateJob
    extends Job
    implements IJobChangeListener {
        private AbstractJob job;
        private boolean reschedule;
        private CommandInterpreter interpreter;
        private int runningCount;
        public static final long DEFAULT_PERIOD = 1000L;

        public CommandInterpreterUpdateJob(AbstractJob job, CommandInterpreter interpreter) {
            super("Process running");
            this.job = null;
            this.reschedule = true;
            this.interpreter = null;
            this.runningCount = 0;
            this.interpreter = interpreter;
            this.job = job;
            job.addJobChangeListener(this);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.reschedule) {
                this.interpreter.println((Object)(String.valueOf(this.getName()) + ": " + this.runningCount));
                ++this.runningCount;
                this.schedule(1000L);
            }
            return Status.OK_STATUS;
        }

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
            this.reschedule = false;
        }

        public void running(IJobChangeEvent event) {
            this.reschedule = true;
            this.schedule();
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void sleeping(IJobChangeEvent event) {
        }
    }
}

