/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.server.repository.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.net4j.db.DBUtil;

public class DBRepositoryUtils {
    public static void executeQuery(DBStore dbStore, String sql) throws SQLException {
        Statement stat = null;
        Connection conn = null;
        try {
            conn = dbStore.getConnection();
            stat = conn.createStatement();
            stat.execute(sql);
            conn.commit();
        }
        catch (Throwable throwable) {
            DBRepositoryUtils.closeSilently(stat);
            DBRepositoryUtils.closeSilently(conn);
            throw throwable;
        }
        DBRepositoryUtils.closeSilently(stat);
        DBRepositoryUtils.closeSilently(conn);
    }

    public static void dropAllTables(DBStore dbStore) throws SQLException {
        Connection conn = dbStore.getConnection();
        DBUtil.dropAllTables((Connection)conn, null);
        try {
            conn.commit();
        }
        finally {
            DBRepositoryUtils.closeSilently(conn);
        }
    }

    public static void closeSilently(Statement stat) {
        DBUtil.close((Statement)stat);
    }

    public static void closeSilently(Connection conn) {
        DBUtil.close((Connection)conn);
    }

    public static long frequency(String propertyValue) {
        long value = 0L;
        if (propertyValue != null) {
            value = Long.valueOf(propertyValue) * 1000L;
        }
        return value;
    }
}

