/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.notation.impl;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.PropertiesSetStyle;
import org.eclipse.gmf.runtime.notation.PropertyValue;
import org.eclipse.gmf.runtime.notation.impl.NamedStyleImpl;

public class PropertiesSetStyleImpl
extends NamedStyleImpl
implements PropertiesSetStyle {
    protected PropertiesSetStyleImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return NotationPackage.Literals.PROPERTIES_SET_STYLE;
    }

    public EMap getPropertiesMap() {
        return (EMap)this.eDynamicGet(1, (EStructuralFeature)NotationPackage.Literals.PROPERTIES_SET_STYLE__PROPERTIES_MAP, true, true);
    }

    public Object getProperty(String propertyName) {
        if (this.hasProperty(propertyName)) {
            return ((PropertyValue)this.getPropertiesMap().get((Object)propertyName)).getValue();
        }
        return null;
    }

    public boolean setProperty(String propertyName, Object newValue) {
        if (this.hasProperty(propertyName)) {
            ((PropertyValue)this.getPropertiesMap().get((Object)propertyName)).setValue(newValue);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createProperty(String propertyName, EDataType instanceType, Object initialValue) {
        if (propertyName == null || this.hasProperty(propertyName)) return false;
        PropertyValue value = NotationFactory.eINSTANCE.createPropertyValue();
        if (instanceType == null) {
            if (!(initialValue instanceof String)) return false;
            value.setRawValue((String)initialValue);
            return this.getPropertiesMap().put((Object)propertyName, (Object)value) == null;
        } else {
            value.setInstanceType(instanceType);
            value.setValue(initialValue);
        }
        return this.getPropertiesMap().put((Object)propertyName, (Object)value) == null;
    }

    public boolean removeProperty(String propertyName) {
        return this.getPropertiesMap().removeKey((Object)propertyName) != null;
    }

    public boolean hasProperty(String propertyName) {
        return this.getPropertiesMap().containsKey((Object)propertyName);
    }

    public boolean createProperty(String propertyName, String initialValue) {
        if (!this.hasProperty(propertyName)) {
            PropertyValue value = NotationFactory.eINSTANCE.createPropertyValue();
            value.setRawValue(initialValue);
            return this.getPropertiesMap().put((Object)propertyName, (Object)value) == null;
        }
        return false;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getPropertiesMap()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                if (coreType) {
                    return this.getPropertiesMap();
                }
                return this.getPropertiesMap().map();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                ((EStructuralFeature.Setting)this.getPropertiesMap()).set(newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.getPropertiesMap().clear();
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.getName() != null : !NAME_EDEFAULT.equals(this.getName());
            }
            case 1: {
                return !this.getPropertiesMap().isEmpty();
            }
        }
        return this.eDynamicIsSet(featureID);
    }
}

