/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.osgi;

import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.concurrent.RWOLockManager;

public class UnlockCDOCommand
extends CDOCommand.WithAccessor {
    public static final String ALL = "-all";

    public UnlockCDOCommand() {
        super("unlock", "remove the locks of a given repository. -all as username will remove all the locks.\n      Note that the opened CDOSession(s) are not notified. Opened CDOSession(s) will have unsynchronized lock status.", new CDOCommand.CommandParameter[]{UnlockCDOCommand.parameter((String)"username")});
    }

    public void execute(InternalRepository repository, IStoreAccessor accessor, String[] args) throws Exception {
        InternalSession[] sessions;
        final String targetUser = args[0];
        InternalLockManager lockingManager = repository.getLockingManager();
        boolean somethingToUnlock = false;
        InternalSessionManager sessionManager = repository.getSessionManager();
        InternalSession[] internalSessionArray = sessions = sessionManager.getSessions();
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            String userID = session.getUserID();
            if (targetUser.equals(ALL) || targetUser.equals(userID)) {
                InternalView[] views;
                InternalView[] internalViewArray = views = session.getViews();
                int n3 = views.length;
                int n4 = 0;
                while (n4 < n3) {
                    InternalView view = internalViewArray[n4];
                    somethingToUnlock = true;
                    lockingManager.unlock2(true, (IView)view);
                    lockingManager.unlock2(false, (IView)view);
                    ++n4;
                }
            }
            ++n2;
        }
        final LinkedHashSet areaIds = new LinkedHashSet();
        repository.getLockingManager().getLockAreas(null, new IDurableLockingManager.LockArea.Handler(){

            public boolean handleLockArea(IDurableLockingManager.LockArea area) {
                String user = area.getUserID();
                if (targetUser.equals(UnlockCDOCommand.ALL) || targetUser.equals(user)) {
                    areaIds.add(area.getDurableLockingID());
                }
                return true;
            }
        });
        List lockStates = repository.getLockingManager().getLockStates();
        LinkedHashSet<IView> views = new LinkedHashSet<IView>();
        for (RWOLockManager.LockState lockState : lockStates) {
            views.add((IView)lockState.getWriteLockOwner());
        }
        for (IView view : views) {
            if (!areaIds.contains(view.getDurableLockingID())) continue;
            somethingToUnlock = true;
            repository.getLockingManager().unlock2(true, view);
        }
        if (somethingToUnlock) {
            this.println("Unlock succeeded.");
        } else {
            this.println("There is nothing to unlock.");
        }
    }
}

