/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ws;

import java.text.MessageFormat;
import org.eclipse.net4j.internal.ws.WSAcceptorManager;
import org.eclipse.net4j.internal.ws.WSServerConnector;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.ws.IWSAcceptor;
import org.eclipse.net4j.ws.jetty.Net4jWebSocket;
import org.eclipse.spi.net4j.Acceptor;
import org.eclipse.spi.net4j.InternalConnector;

public class WSAcceptor
extends Acceptor
implements IWSAcceptor {
    public static final boolean DEFAULT_START_SYNCHRONOUSLY = true;
    public static final long DEFAULT_SYNCHRONOUS_START_TIMEOUT = 10000L;
    private String name;
    private String type = "ws";

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkInactive();
        this.name = name;
    }

    public void setType(String type) {
        this.checkInactive();
        this.type = type;
    }

    public WSServerConnector handleAccept(Net4jWebSocket webSocket) {
        WSServerConnector connector = this.createConnector();
        this.prepareConnector((InternalConnector)connector);
        connector.setWebSocket(webSocket);
        connector.activate();
        this.addConnector((InternalConnector)connector);
        return connector;
    }

    public String toString() {
        if (!"ws".equalsIgnoreCase(this.type)) {
            return MessageFormat.format("WSAcceptor[{0}, {1}]", this.type, this.name);
        }
        return MessageFormat.format("WSAcceptor[{0}]", this.name);
    }

    protected WSServerConnector createConnector() {
        return new WSServerConnector(this);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (StringUtil.isEmpty((String)this.name)) {
            throw new IllegalStateException("name is null or empty");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        WSAcceptorManager.INSTANCE.registerAcceptor(this);
    }

    protected void doDeactivate() throws Exception {
        WSAcceptorManager.INSTANCE.deregisterAcceptor(this);
        super.doDeactivate();
    }
}

