/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.ldap;

import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.IAuthenticatorConfigFactory;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.ldap.LDAPAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.ldap.LDAPAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.configuration.CollabServerConfigPropertiesHelper;
import java.io.File;
import java.util.Properties;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.security.AuthenticatorFactory;

public class LDAPAuthenticatorFactory
extends AuthenticatorFactory
implements IFactory,
IAuthenticatorConfigFactory {
    public static final String AUTHENTICATOR_TYPE = "ldap";

    public LDAPAuthenticatorFactory() {
        super(AUTHENTICATOR_TYPE);
    }

    public Object create(String description) throws ProductCreationException {
        LDAPAuthenticatorConfig config = this.getConfigFromDescription(description);
        return new LDAPAuthenticator(config);
    }

    protected LDAPAuthenticatorConfig getConfigFromDescription(String configurationFilePath) throws ProductCreationException {
        CollabServerConfigPropertiesHelper helper = new CollabServerConfigPropertiesHelper(configurationFilePath, "LDAP authenticator");
        helper.load();
        return new LDAPAuthenticatorConfig(helper.getProperties(), helper.getConfigFile().getParentFile());
    }

    @Override
    public IAuthenticatorConfig createAuthenticatorConfig(Properties authProperties, File configurationFolder) {
        return new LDAPAuthenticatorConfig(authProperties, configurationFolder);
    }
}

