/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.configuration;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public class CollabServerConfigPropertiesHelper {
    private static final String CONFIGURATION_FILE_IS_NOT_A_FILE = "{0} configuration file is not a file ({1}).";
    private static final String CONFIGURATION_FILE_CANNOT_BE_LOADED = "{0} configuration file cannot be loaded ({1}).";
    private static final String CONFIGURATION_FILE_CANNOT_BE_FOUND = "{0} configuration file cannot be found ({1}).";
    private static final String NO_DESCRIPTION_ATTRIBUTE_FOR_0_IN_CDO_CONFIG_FILE = "No description attribute for {0} in cdo config file.";
    private final String filePath;
    private Properties properties;
    private File configFile;
    private final String type;

    public CollabServerConfigPropertiesHelper(String configurationFilePath, String type) {
        this.filePath = configurationFilePath;
        this.type = type;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public final void load() {
        if (this.filePath == null) {
            throw new ProductCreationException(MessageFormat.format(NO_DESCRIPTION_ATTRIBUTE_FOR_0_IN_CDO_CONFIG_FILE, this.type));
        }
        this.configFile = OMPlatform.INSTANCE.getConfigFile(this.filePath);
        try {
            this.properties = this.getPropertiesFromFile();
        }
        catch (ProductCreationException e) {
            this.configFile = new File(this.filePath);
            this.properties = this.getPropertiesFromFile();
        }
    }

    private Properties getPropertiesFromFile() throws ProductCreationException {
        if (!this.configFile.exists()) {
            throw new ProductCreationException(MessageFormat.format(CONFIGURATION_FILE_CANNOT_BE_FOUND, this.type, this.filePath));
        }
        if (!this.configFile.isFile()) {
            throw new ProductCreationException(MessageFormat.format(CONFIGURATION_FILE_IS_NOT_A_FILE, this.type, this.filePath));
        }
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(this.configFile);
                props.load(fis);
            }
            catch (FileNotFoundException e) {
                throw new ProductCreationException(MessageFormat.format(CONFIGURATION_FILE_CANNOT_BE_FOUND, this.type, this.filePath), (Throwable)e);
            }
            catch (IOException e) {
                throw new ProductCreationException(MessageFormat.format(CONFIGURATION_FILE_CANNOT_BE_LOADED, this.type, this.filePath), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(fis);
            throw throwable;
        }
        IOUtil.close((Closeable)fis);
        return props;
    }
}

