/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.adm.common.locks;

import com.thalesgroup.mde.melody.collab.adm.common.locks.LockAreaMessages;
import com.thalesgroup.mde.melody.collab.adm.common.net4j.object.IRemoteAdminObject;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataInput;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.osgi.util.NLS;

public class CDOLockAreaBuffer
implements IRemoteAdminObject {
    protected String _durableLockingID;
    protected String _repositoryID;
    protected String _userID;
    protected int _branchID;
    protected long _timeStamp;
    protected boolean _isReadOnly;
    protected Map<CDOID, IDurableLockingManager.LockGrade> _locks = new HashMap<CDOID, IDurableLockingManager.LockGrade>();

    protected CDOLockAreaBuffer() {
    }

    public static CDOLockAreaBuffer dump(IDurableLockingManager.LockArea lockArea, String repositoryID) {
        CDOLockAreaBuffer result = null;
        if (lockArea != null) {
            result = new CDOLockAreaBuffer();
            result._durableLockingID = lockArea.getDurableLockingID();
            result._repositoryID = repositoryID;
            result._userID = lockArea.getUserID();
            result._branchID = lockArea.getBranch().getID();
            result._timeStamp = lockArea.getTimeStamp();
            result._locks = lockArea.getLocks();
            result._isReadOnly = lockArea.isReadOnly();
            Map locks_r = lockArea.getLocks();
            if (locks_r != null && !locks_r.isEmpty()) {
                result._locks.putAll(locks_r);
            }
        }
        return result;
    }

    public static CDOLockAreaBuffer read(IRemoteAdminDataInput in) {
        CDOLockAreaBuffer result = null;
        if (in != null) {
            CDOLockAreaBuffer tmp = new CDOLockAreaBuffer();
            try {
                result = (CDOLockAreaBuffer)tmp.readValue(in);
            }
            catch (IOException exception_p) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public Object readValue(IRemoteAdminDataInput in) throws IOException {
        CDOLockAreaBuffer result = null;
        if (in != null) {
            result = new CDOLockAreaBuffer();
            result._durableLockingID = in.readString();
            result._repositoryID = in.readString();
            result._userID = in.readString();
            result._branchID = in.readInt();
            result._timeStamp = in.readLong();
            result._isReadOnly = in.readBoolean();
            result._locks = new HashMap<CDOID, IDurableLockingManager.LockGrade>();
            int size = in.readInt();
            int i = 0;
            while (i < size) {
                CDOID key = in.readCDOID();
                int value = in.readInt();
                result._locks.put(key, IDurableLockingManager.LockGrade.get((int)value));
                ++i;
            }
        }
        return result;
    }

    @Override
    public void writeValue(IRemoteAdminDataOutput out) throws IOException {
        if (out != null) {
            out.writeString(this._durableLockingID);
            out.writeString(this._repositoryID);
            out.writeString(this._userID);
            out.writeInt(this._branchID);
            out.writeLong(this._timeStamp);
            out.writeBoolean(this._isReadOnly);
            out.writeInt(this._locks.size());
            Iterator<Map.Entry<CDOID, IDurableLockingManager.LockGrade>> it = this._locks.entrySet().iterator();
            Map.Entry<CDOID, IDurableLockingManager.LockGrade> current = null;
            while (it.hasNext()) {
                current = it.next();
                out.writeCDOID(current.getKey());
                out.writeInt(current.getValue().getValue());
            }
        }
    }

    public String toString() {
        String result = "";
        result = String.valueOf(result) + NLS.bind((String)LockAreaMessages.toString_lockID, (Object)this._durableLockingID);
        result = String.valueOf(result) + ' ' + NLS.bind((String)LockAreaMessages.toString_repositoryID, (Object)this._repositoryID);
        result = String.valueOf(result) + ' ' + NLS.bind((String)LockAreaMessages.toString_userID, (Object)this._userID);
        result = String.valueOf(result) + ' ' + NLS.bind((String)LockAreaMessages.toString_branchID, (Object)Long.toString(this._branchID));
        result = String.valueOf(result) + ' ' + NLS.bind((String)LockAreaMessages.toString_timeStamp, (Object)CDOCommonUtil.formatTimeStamp((long)this._timeStamp));
        result = String.valueOf(result) + ' ' + NLS.bind((String)LockAreaMessages.toString_isReadOnly, (Object)Boolean.toString(this._isReadOnly));
        result = String.valueOf(result) + ' ' + NLS.bind((String)LockAreaMessages.toString_locksSize, (Object)(this._locks != null ? Integer.toString(this._locks.size()) : "---"));
        return result;
    }

    public String getDurableLockingID() {
        return this._durableLockingID;
    }

    public String getRepositoryID() {
        return this._repositoryID;
    }

    public String getUserID() {
        return this._userID;
    }

    public int getBranchID() {
        return this._branchID;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public Map<CDOID, IDurableLockingManager.LockGrade> getLocks() {
        return this._locks;
    }
}

