/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.adm.common.net4j.object;

import com.thalesgroup.mde.melody.collab.adm.common.net4j.object.IRemoteAdminObject;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataInput;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataOutput;
import java.io.IOException;
import org.eclipse.core.runtime.Assert;

public class ElementObject
implements IRemoteAdminObject {
    private String productGroupID;
    private String type;
    private String description;

    private ElementObject() {
    }

    public ElementObject(String ... triplet) {
        Assert.isTrue((triplet != null && 2 < triplet.length ? 1 : 0) != 0);
        this.init(triplet[0], triplet[1], triplet[2]);
    }

    public ElementObject(String productGroupID, String type, String description) {
        this.init(productGroupID, type, description);
    }

    public String getProductGroupID() {
        return this.productGroupID;
    }

    public final String getType() {
        return this.type;
    }

    public final String getDescription() {
        return this.description;
    }

    public final boolean hasDescription() {
        return this.description != null && this.description.length() != 0;
    }

    public boolean isEqualTo(ElementObject elementObject) {
        boolean result = elementObject != null && this.type.equals(elementObject.getType()) && (this.description == null && elementObject.getDescription() == null || this.description != null && this.description.equals(elementObject.getDescription()));
        return result;
    }

    public static ElementObject read(IRemoteAdminDataInput in) {
        ElementObject result = null;
        if (in != null) {
            result = new ElementObject();
            try {
                result = (ElementObject)result.readValue(in);
            }
            catch (IOException exception_p) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public Object readValue(IRemoteAdminDataInput in) throws IOException {
        ElementObject result = null;
        if (in != null) {
            String productGroupID = in.readString();
            String type = in.readString();
            boolean hasDescription = in.readBoolean();
            String description = hasDescription ? in.readString() : null;
            result = new ElementObject(productGroupID, type, description);
        }
        return result;
    }

    @Override
    public void writeValue(IRemoteAdminDataOutput out) throws IOException {
        if (out != null) {
            out.writeString(this.productGroupID);
            out.writeString(this.type);
            boolean hasDescription = this.hasDescription();
            out.writeBoolean(hasDescription);
            if (hasDescription) {
                out.writeString(this.description);
            }
        }
    }

    private void init(String productGroupID, String type, String description) {
        Assert.isTrue((productGroupID != null && productGroupID.length() != 0 && type != null && type.length() != 0 ? 1 : 0) != 0);
        this.productGroupID = productGroupID;
        this.type = type;
        this.description = description;
    }
}

