/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.adm.common.net4j.object;

import com.thalesgroup.mde.melody.collab.adm.common.net4j.object.IRemoteAdminObject;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataInput;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataOutput;
import java.io.IOException;
import org.eclipse.core.runtime.Assert;

public class UserDataObject
implements IRemoteAdminObject {
    private String _userID;
    private char[] _password;

    private UserDataObject() {
    }

    public UserDataObject(String userID) {
        this._userID = userID;
        this._password = "".toCharArray();
    }

    public UserDataObject(String userID, char[] password) {
        Assert.isNotNull((Object)userID);
        this._userID = userID;
        this._password = password;
    }

    public final String getUserID() {
        return this._userID;
    }

    public final char[] getPassword() {
        return this._password;
    }

    public final boolean hasPassword() {
        return this._password != null && this._password.length > 0;
    }

    public static UserDataObject read(IRemoteAdminDataInput in) {
        UserDataObject result = null;
        if (in != null) {
            result = new UserDataObject();
            try {
                result = (UserDataObject)result.readValue(in);
            }
            catch (IOException exception_p) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public Object readValue(IRemoteAdminDataInput in) throws IOException {
        UserDataObject result = null;
        if (in != null) {
            result = new UserDataObject(in.readString(), this.readPassword(in));
        }
        return result;
    }

    @Override
    public void writeValue(IRemoteAdminDataOutput out) throws IOException {
        if (out != null) {
            out.writeString(this._userID);
            this.writePassword(out);
        }
    }

    private char[] readPassword(IRemoteAdminDataInput in) throws IOException {
        int sz = in.readInt();
        char[] pwd = new char[sz];
        int i = 0;
        while (i < sz) {
            pwd[i] = in.readChar();
            ++i;
        }
        return pwd;
    }

    private void writePassword(IRemoteAdminDataOutput out) throws IOException {
        if (this.hasPassword()) {
            out.writeInt(this._password.length);
            int i = 0;
            while (i < this._password.length) {
                out.writeChar(this._password[i]);
                ++i;
            }
        } else {
            out.writeInt(0);
        }
    }
}

