/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.adm.server.protocol;

import com.thalesgroup.mde.melody.collab.adm.common.net4j.AbstractRemoteAdminIndicationWithResponse;
import com.thalesgroup.mde.melody.collab.adm.common.net4j.object.AcknowledgmentObject;
import com.thalesgroup.mde.melody.collab.adm.common.net4j.object.ElementObject;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataInput;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataOutput;
import com.thalesgroup.mde.melody.collab.adm.server.messages.AdmServerMessages;
import com.thalesgroup.mde.melody.collab.adm.server.protocol.RemoteAdminServerProtocol;
import com.thalesgroup.mde.melody.collab.adm.services.utils.CollabAdminServices;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.osgi.util.NLS;

public final class GetElementsIndication
extends AbstractRemoteAdminIndicationWithResponse {
    private String productGroupID;

    public GetElementsIndication(RemoteAdminServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)101);
    }

    protected void indicating(IRemoteAdminDataInput in) throws IOException {
        this.productGroupID = in.readString();
    }

    protected void responding(IRemoteAdminDataOutput out) throws IOException {
        AcknowledgmentObject ack = null;
        Collection elements = CollabAdminServices.getRegisteredElementForProductGroup((String)this.productGroupID);
        ack = new AcknowledgmentObject(!elements.isEmpty(), NLS.bind((String)AdmServerMessages.err_noElementRegisteredForProductGroup, (Object)this.productGroupID));
        out.writeAknowledgement(ack);
        if (ack.isStatusOk()) {
            ArrayList<ElementObject> eltsToSend = new ArrayList<ElementObject>(elements.size());
            for (Object element : elements) {
                eltsToSend.add(new ElementObject(CollabAdminServices.getPluginContainer().getElementKey(element)));
            }
            out.writeElements(eltsToSend);
        }
    }
}

