/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.h2.contribution;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AbstractRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.h2.internal.H2AdminConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.h2.internal.H2RepositoryManagerUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.h2.internal.H2ServerProcessManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.server.IRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class H2ServerRepositoryManager
extends AbstractRepositoryManager
implements IRepositoryManager {
    private static final String KEY = "H2_SERVER";
    @Deprecated
    private static final String H2_SERVER_DATABASE_PORT_KEY_DEPRECATED = "port";
    private static final String H2_SERVER_DATABASE_PORT_KEY = "h2ServerPort";
    private static final String DEFAULT_H2_SERVER_DATABASE_PORT_VALUE = "9092";
    private static final String DEFAULT_H2_SERVER_DATABASE_HOST_VALUE = "localhost";

    public IStatus preStart(RepositoryData repositoryData) {
        super.preStart(repositoryData);
        return this.ensureH2ServerIsRunning(repositoryData);
    }

    private IStatus ensureH2ServerIsRunning(RepositoryData repositoryData) {
        boolean started = this.isH2ServerRunning(repositoryData);
        IStatus status = Status.OK_STATUS;
        String xmxValue = "-Xmx" + repositoryData.getDatasourceData().get("Xmx");
        if (!started) {
            try {
                status = H2ServerProcessManager.getInstance().createNewH2ServerProcess(DEFAULT_H2_SERVER_DATABASE_HOST_VALUE, String.valueOf(repositoryData.getDatasourceData().get(H2_SERVER_DATABASE_PORT_KEY)), String.valueOf(repositoryData.getDatasourceData().get("baseDir")), xmxValue);
            }
            catch (IOException e) {
                OM.LOG.error("The h2 server was not able to start.", (Throwable)e);
                status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin.h2", "The h2 server was not able to start.", (Throwable)e);
            }
        }
        return status;
    }

    private boolean isH2ServerRunning(RepositoryData repositoryData) {
        boolean isRunning = false;
        try {
            Class.forName("org.h2.Driver");
            Connection connection = DriverManager.getConnection(this.buildUrl(repositoryData));
            connection.close();
            isRunning = true;
        }
        catch (ClassNotFoundException | SQLException exception) {
            // empty catch block
        }
        return isRunning;
    }

    public IStatus postStop(RepositoryData repositoryData) {
        IStatus status;
        String processKey = String.valueOf(repositoryData.getDatasourceData().get("baseDir"));
        if (H2ServerProcessManager.getInstance().hasProcessFor(processKey)) {
            boolean processKilled = H2ServerProcessManager.getInstance().killProcess(processKey);
            if (!processKilled) {
                status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin.h2", String.format("The process used by the %1$s repository has not been destroy.", repositoryData.getRepositoryName()));
                this.logTask("Post-stop", repositoryData);
            } else {
                status = super.postStop(repositoryData);
            }
        } else {
            status = super.postStop(repositoryData);
        }
        return status;
    }

    public void manage(Document document, Element parentElement, RepositoryData repositoryData) {
        repositoryData.getDatasourceData().put("Xmx", H2AdminConfigurationHelper.getDefaultH2ServerXmx());
        H2RepositoryManagerUtil.createTag2HandleH2Database(document, parentElement, this.buildUrl(repositoryData));
    }

    private String buildUrl(RepositoryData repositoryData) {
        Map datasourceData = repositoryData.getDatasourceData();
        StringBuilder urlBuilder = new StringBuilder("jdbc:h2:tcp://");
        urlBuilder.append(DEFAULT_H2_SERVER_DATABASE_HOST_VALUE);
        Object portObject = datasourceData.get(H2_SERVER_DATABASE_PORT_KEY_DEPRECATED);
        if (portObject == null) {
            portObject = datasourceData.getOrDefault(H2_SERVER_DATABASE_PORT_KEY, DEFAULT_H2_SERVER_DATABASE_PORT_VALUE);
        }
        int port = portObject instanceof Double ? ((Double)portObject).intValue() : Integer.valueOf(String.valueOf(portObject)).intValue();
        datasourceData.put(H2_SERVER_DATABASE_PORT_KEY, port);
        urlBuilder.append(':');
        urlBuilder.append(port);
        urlBuilder.append('/');
        String path = String.valueOf(repositoryData.getConfigurationFolderPath());
        if (!"".equals(path)) {
            path = String.valueOf(path) + File.separator;
        }
        path = String.valueOf(path) + repositoryData.getRepositoryName() + File.separator;
        path = String.valueOf(path) + "_database";
        repositoryData.getDatasourceData().put("baseDir", path);
        path = String.valueOf(path) + File.separator + repositoryData.getRepositoryName();
        urlBuilder.append(path);
        return urlBuilder.toString();
    }

    public Optional<IRepository> prepareRepositoryForImport(RepositoryData repositoryData) {
        this.ensureH2ServerIsRunning(repositoryData);
        return H2RepositoryManagerUtil.createRepositoryFromConfiguration(repositoryData.getRepositoryName());
    }

    public String getKey() {
        return KEY;
    }

    public String validateData(Map<String, Object> data) {
        String stringValue = null;
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        Object portObject = data.get(H2_SERVER_DATABASE_PORT_KEY_DEPRECATED);
        if (portObject == null) {
            portObject = data.get(H2_SERVER_DATABASE_PORT_KEY);
        }
        if (!(portObject instanceof Double) && portObject != null) {
            try {
                stringValue = String.valueOf(portObject);
                Integer.valueOf(stringValue);
            }
            catch (NumberFormatException e) {
                diagnostic = "The port number must be an integer.";
            }
        }
        if (portObject instanceof Double && stringValue == null) {
            stringValue = String.valueOf(((Double)portObject).intValue());
        }
        if ("NO_ISSUE_DIAGNOSTIC".equals(diagnostic) && stringValue != null && H2ServerProcessManager.getInstance().hasProcessForPort(stringValue)) {
            diagnostic = "The port number is already in use by another H2 Server.";
        }
        return diagnostic;
    }

    public String validateNewUser(NewUser newUser, String repositoryName) {
        return "Users are not managed by this repository manager.";
    }
}

