/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint.impl;

import com.google.common.base.Splitter;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.model.business.internal.spec.DViewSpec;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DAnalysisCustomData;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.DFile;
import org.eclipse.sirius.viewpoint.DFolder;
import org.eclipse.sirius.viewpoint.DModel;
import org.eclipse.sirius.viewpoint.DProject;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DResourceContainer;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.Decoration;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.LabelAlignment;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.MetaModelExtension;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.SessionManagerEObject;
import org.eclipse.sirius.viewpoint.SyncStatus;
import org.eclipse.sirius.viewpoint.ToolGroupInstance;
import org.eclipse.sirius.viewpoint.ToolInstance;
import org.eclipse.sirius.viewpoint.ToolSectionInstance;
import org.eclipse.sirius.viewpoint.UIState;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.impl.BasicLabelStyleImpl;
import org.eclipse.sirius.viewpoint.impl.DAnalysisCustomDataImpl;
import org.eclipse.sirius.viewpoint.impl.DAnalysisImpl;
import org.eclipse.sirius.viewpoint.impl.DAnalysisSessionEObjectImpl;
import org.eclipse.sirius.viewpoint.impl.DFileImpl;
import org.eclipse.sirius.viewpoint.impl.DFolderImpl;
import org.eclipse.sirius.viewpoint.impl.DModelImpl;
import org.eclipse.sirius.viewpoint.impl.DProjectImpl;
import org.eclipse.sirius.viewpoint.impl.DRepresentationDescriptorImpl;
import org.eclipse.sirius.viewpoint.impl.DResourceContainerImpl;
import org.eclipse.sirius.viewpoint.impl.DecorationImpl;
import org.eclipse.sirius.viewpoint.impl.LabelStyleImpl;
import org.eclipse.sirius.viewpoint.impl.MetaModelExtensionImpl;
import org.eclipse.sirius.viewpoint.impl.SessionManagerEObjectImpl;
import org.eclipse.sirius.viewpoint.impl.ToolGroupInstanceImpl;
import org.eclipse.sirius.viewpoint.impl.ToolInstanceImpl;
import org.eclipse.sirius.viewpoint.impl.ToolSectionInstanceImpl;
import org.eclipse.sirius.viewpoint.impl.UIStateImpl;

public class ViewpointFactoryImpl
extends EFactoryImpl
implements ViewpointFactory {
    public static ViewpointFactory init() {
        try {
            ViewpointFactory theViewpointFactory = (ViewpointFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/sirius/1.1.0");
            if (theViewpointFactory != null) {
                return theViewpointFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ViewpointFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createDAnalysis();
            }
            case 7: {
                return this.createDRepresentationDescriptor();
            }
            case 10: {
                return this.createDView();
            }
            case 11: {
                return this.createMetaModelExtension();
            }
            case 12: {
                return this.createDecoration();
            }
            case 13: {
                return this.createDAnalysisCustomData();
            }
            case 14: {
                return this.createLabelStyle();
            }
            case 16: {
                return this.createDAnalysisSessionEObject();
            }
            case 17: {
                return this.createSessionManagerEObject();
            }
            case 19: {
                return this.createDFile();
            }
            case 20: {
                return this.createDResourceContainer();
            }
            case 21: {
                return this.createDProject();
            }
            case 22: {
                return this.createDFolder();
            }
            case 23: {
                return this.createDModel();
            }
            case 24: {
                return this.createBasicLabelStyle();
            }
            case 26: {
                return this.createUIState();
            }
            case 27: {
                return this.createToolInstance();
            }
            case 28: {
                return this.createToolGroupInstance();
            }
            case 29: {
                return this.createToolSectionInstance();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 30: {
                return this.createFontFormatFromString(eDataType, initialValue);
            }
            case 31: {
                return this.createLabelAlignmentFromString(eDataType, initialValue);
            }
            case 32: {
                return this.createSyncStatusFromString(eDataType, initialValue);
            }
            case 33: {
                return this.createRGBValuesFromString(eDataType, initialValue);
            }
            case 34: {
                return this.createResourceDescriptorFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 30: {
                return this.convertFontFormatToString(eDataType, instanceValue);
            }
            case 31: {
                return this.convertLabelAlignmentToString(eDataType, instanceValue);
            }
            case 32: {
                return this.convertSyncStatusToString(eDataType, instanceValue);
            }
            case 33: {
                return this.convertRGBValuesToString(eDataType, instanceValue);
            }
            case 34: {
                return this.convertResourceDescriptorToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public DAnalysis createDAnalysis() {
        DAnalysisImpl dAnalysis = new DAnalysisImpl();
        return dAnalysis;
    }

    public DRepresentationDescriptor createDRepresentationDescriptor() {
        DRepresentationDescriptorImpl dRepresentationDescriptor = new DRepresentationDescriptorImpl();
        return dRepresentationDescriptor;
    }

    public DView createDView() {
        DViewSpec dView = new DViewSpec();
        return dView;
    }

    public MetaModelExtension createMetaModelExtension() {
        MetaModelExtensionImpl metaModelExtension = new MetaModelExtensionImpl();
        return metaModelExtension;
    }

    public Decoration createDecoration() {
        DecorationImpl decoration = new DecorationImpl();
        return decoration;
    }

    public DAnalysisCustomData createDAnalysisCustomData() {
        DAnalysisCustomDataImpl dAnalysisCustomData = new DAnalysisCustomDataImpl();
        return dAnalysisCustomData;
    }

    public LabelStyle createLabelStyle() {
        LabelStyleImpl labelStyle = new LabelStyleImpl();
        return labelStyle;
    }

    public DAnalysisSessionEObject createDAnalysisSessionEObject() {
        DAnalysisSessionEObjectImpl dAnalysisSessionEObject = new DAnalysisSessionEObjectImpl();
        return dAnalysisSessionEObject;
    }

    public SessionManagerEObject createSessionManagerEObject() {
        SessionManagerEObjectImpl sessionManagerEObject = new SessionManagerEObjectImpl();
        return sessionManagerEObject;
    }

    public DFile createDFile() {
        DFileImpl dFile = new DFileImpl();
        return dFile;
    }

    public DResourceContainer createDResourceContainer() {
        DResourceContainerImpl dResourceContainer = new DResourceContainerImpl();
        return dResourceContainer;
    }

    public DProject createDProject() {
        DProjectImpl dProject = new DProjectImpl();
        return dProject;
    }

    public DFolder createDFolder() {
        DFolderImpl dFolder = new DFolderImpl();
        return dFolder;
    }

    public DModel createDModel() {
        DModelImpl dModel = new DModelImpl();
        return dModel;
    }

    public BasicLabelStyle createBasicLabelStyle() {
        BasicLabelStyleImpl basicLabelStyle = new BasicLabelStyleImpl();
        return basicLabelStyle;
    }

    public UIState createUIState() {
        UIStateImpl uiState = new UIStateImpl();
        return uiState;
    }

    public ToolInstance createToolInstance() {
        ToolInstanceImpl toolInstance = new ToolInstanceImpl();
        return toolInstance;
    }

    public ToolGroupInstance createToolGroupInstance() {
        ToolGroupInstanceImpl toolGroupInstance = new ToolGroupInstanceImpl();
        return toolGroupInstance;
    }

    public ToolSectionInstance createToolSectionInstance() {
        ToolSectionInstanceImpl toolSectionInstance = new ToolSectionInstanceImpl();
        return toolSectionInstance;
    }

    public FontFormat createFontFormatFromString(EDataType eDataType, String initialValue) {
        FontFormat result = FontFormat.get((String)initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFontFormatToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public LabelAlignment createLabelAlignmentFromString(EDataType eDataType, String initialValue) {
        LabelAlignment result = LabelAlignment.get((String)initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertLabelAlignmentToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public SyncStatus createSyncStatusFromString(EDataType eDataType, String initialValue) {
        SyncStatus result = SyncStatus.get((String)initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSyncStatusToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RGBValues createRGBValuesFromString(EDataType eDataType, String initialValue) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (!ViewpointFactoryImpl.isEmpty(initialValue)) {
            Iterator it = Splitter.on((char)',').split((CharSequence)initialValue).iterator();
            if (it.hasNext()) {
                r = this.toInt((String)it.next());
            }
            if (it.hasNext()) {
                g = this.toInt((String)it.next());
            }
            if (it.hasNext()) {
                b = this.toInt((String)it.next());
            }
        }
        return RGBValues.create((int)r, (int)g, (int)b);
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private int toInt(String next) {
        if (next.length() > 0) {
            try {
                return Integer.valueOf(next);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public String convertRGBValuesToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue instanceof RGBValues) {
            return instanceValue.toString();
        }
        return super.convertToString(eDataType, instanceValue);
    }

    public ResourceDescriptor createResourceDescriptorFromString(EDataType eDataType, String initialValue) {
        return (ResourceDescriptor)super.createFromString(eDataType, initialValue);
    }

    public String convertResourceDescriptorToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public ViewpointPackage getViewpointPackage() {
        return (ViewpointPackage)this.getEPackage();
    }

    @Deprecated
    public static ViewpointPackage getPackage() {
        return ViewpointPackage.eINSTANCE;
    }

    public RGBValues createRGBValues() {
        return RGBValues.create((int)0, (int)0, (int)0);
    }
}

