/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.user.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.cdo.security.Permission;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.RealmUtil;
import org.eclipse.emf.cdo.security.ResourcePermission;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class UserProfileUtil {
    public static final String SESSION_RESOURCE_EXTENSION = "aird";
    public static final String REPRESENTATION_FILE_EXTENSION = "srm";
    public static final String REPRESENTATIONS_FOLDER_NAME = ".representations";
    public static final String PATH_PATTERN = ".*\\.";
    public static final String REPRESENTATIONS_PATTERN = ".*/\\.representations";
    public static final String AIRD_PATTERN = ".*\\.aird";
    public static final String SRM_PATTERN = ".*\\.srm";
    public static final String FOLDER_PERMISSION_ROLE = "FOLDER_PERMISSION_ROLE";
    public static final String CREATE_AND_MODIFY_REPRESENTATION_ROLE = "CREATE_AND_MODIFY_REPRESENTATION_ROLE";
    public static final String MODIFY_REPRESENTATION_ROLE = "MODIFY_REPRESENTATION_ROLE";
    public static final String MODIFY_SEMANTIC_ROLE = "MODIFY_SEMANTIC_ROLE";
    public static final String EXPORT_PROJECT_ROLE = "EXPORT_PROJECT_ROLE";

    private UserProfileUtil() {
    }

    public static void addMissingTechnicalRoles(Realm realm) {
        List<String> missingTechnicalRolesId = UserProfileUtil.getMissingTechnicalRoles(realm);
        if (missingTechnicalRolesId.contains(FOLDER_PERMISSION_ROLE)) {
            UserProfileUtil.addRoleWithResourcePermission(realm, FOLDER_PERMISSION_ROLE, REPRESENTATIONS_PATTERN);
        } else if (missingTechnicalRolesId.contains(CREATE_AND_MODIFY_REPRESENTATION_ROLE)) {
            UserProfileUtil.addRoleWithResourcePermission(realm, CREATE_AND_MODIFY_REPRESENTATION_ROLE, REPRESENTATIONS_PATTERN);
        }
    }

    private static List<String> getMissingTechnicalRoles(Realm realm) {
        ArrayList<String> technicalRolesId = new ArrayList<String>();
        for (Role role : realm.getAllRoles()) {
            if (!role.getId().equals(CREATE_AND_MODIFY_REPRESENTATION_ROLE) || role.getPermissions().size() < 2) continue;
            Object firstPattern = ((Permission)role.getPermissions().get(0)).eGet((EStructuralFeature)SecurityPackage.eINSTANCE.getResourcePermission_Pattern());
            Object secondPattern = ((Permission)role.getPermissions().get(1)).eGet((EStructuralFeature)SecurityPackage.eINSTANCE.getResourcePermission_Pattern());
            if (!SRM_PATTERN.equals(firstPattern) || !AIRD_PATTERN.equals(secondPattern)) continue;
            if (role.getPermissions().size() != 3 || !REPRESENTATIONS_PATTERN.equals(((Permission)role.getPermissions().get(2)).eGet((EStructuralFeature)SecurityPackage.eINSTANCE.getResourcePermission_Pattern()))) {
                technicalRolesId.add(CREATE_AND_MODIFY_REPRESENTATION_ROLE);
            }
            return technicalRolesId;
        }
        technicalRolesId.add(FOLDER_PERMISSION_ROLE);
        for (Role role : realm.getAllRoles()) {
            if (!role.getId().equals(FOLDER_PERMISSION_ROLE)) continue;
            technicalRolesId.remove(FOLDER_PERMISSION_ROLE);
            break;
        }
        return technicalRolesId;
    }

    public static Collection<Role> getTechnicalRoles(Realm realm) {
        return RealmUtil.allRoles((EList)realm.getItems()).stream().filter(role -> FOLDER_PERMISSION_ROLE.equals(role.getId())).collect(Collectors.toList());
    }

    public static void initializeRoles(Realm realm) {
        UserProfileUtil.addRoleWithResourcePermission(realm, EXPORT_PROJECT_ROLE, "/");
        UserProfileUtil.addRoleWithResourcePermission(realm, CREATE_AND_MODIFY_REPRESENTATION_ROLE, SRM_PATTERN, AIRD_PATTERN, REPRESENTATIONS_PATTERN);
        UserProfileUtil.addRoleWithResourcePermission(realm, MODIFY_REPRESENTATION_ROLE, SRM_PATTERN, AIRD_PATTERN);
    }

    public static void initializeRoles(Realm realm, Collection<String> permissionSemanticFileExtensions) {
        UserProfileUtil.initializeRoles(realm);
        for (String permissionSemanticFileExtension : permissionSemanticFileExtensions) {
            UserProfileUtil.addRoleWithResourcePermission(realm, MODIFY_SEMANTIC_ROLE, PATH_PATTERN + permissionSemanticFileExtension);
        }
    }

    private static void addRoleWithResourcePermission(Realm realm, String roleId, String ... regexes) {
        Role role = UserProfileUtil.findOrCreateRole(realm, roleId);
        String[] stringArray = regexes;
        int n = regexes.length;
        int n2 = 0;
        while (n2 < n) {
            String regex = stringArray[n2];
            ResourcePermission resPermission = SecurityFactory.eINSTANCE.createResourcePermission();
            resPermission.setPattern(regex);
            role.getPermissions().add((Object)resPermission);
            ++n2;
        }
    }

    private static Role findOrCreateRole(Realm realm, String roleId) {
        Role role2;
        for (Role role2 : realm.getAllRoles()) {
            if (!role2.getId().equals(roleId)) continue;
            return role2;
        }
        role2 = SecurityFactory.eINSTANCE.createRole(roleId);
        EList items = realm.getItems();
        items.add(role2);
        return role2;
    }
}

