/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.user.profile.export;

import fr.obeo.dsl.viewpoint.collab.user.profile.Activator;
import fr.obeo.dsl.viewpoint.collab.user.profile.UserProfileUtil;
import fr.obeo.dsl.viewpoint.collab.user.profile.internal.util.CDOURIDataHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.cdo.common.security.NoPermissionException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOURIData;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.container.FactoryNotFoundException;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleState;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;
import org.eclipse.spi.net4j.Connector;

public class UserProfileModelExporter {
    private static final String PROPERTY_ID = "password";
    private static final String GROUP_ID = "org.eclipse.net4j.util.credentialsProviders";
    private static final String ERROR_MESSAGE = "Failed to export the user profile model : ";
    private URI localUserProfileModelResourceURI;
    private URI remoteUserProfileModelResourceURI;

    public UserProfileModelExporter(URI localUserProfileModelResourceURI, URI remoteUserProfileModelResourceURI) {
        this.localUserProfileModelResourceURI = localUserProfileModelResourceURI;
        this.remoteUserProfileModelResourceURI = remoteUserProfileModelResourceURI;
    }

    /*
     * Loose catch block
     */
    public Diagnostic process(IProgressMonitor monitor) {
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        try {
            try {
                monitor.beginTask("Export the user profile model", 2);
                diagnostic = this.export(monitor, true);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "fr.obeo.dsl.viewpoint.collab.user.profile", ERROR_MESSAGE + e.getLocalizedMessage(), (Throwable)e));
                monitor.done();
            }
            catch (NoPermissionException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "fr.obeo.dsl.viewpoint.collab.user.profile", ERROR_MESSAGE + e.getLocalizedMessage(), (Throwable)e));
                monitor.done();
            }
            catch (InvalidURIException e) {
                try {
                    this.export(monitor, false);
                }
                catch (IOException e1) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "fr.obeo.dsl.viewpoint.collab.user.profile", ERROR_MESSAGE + e1.getLocalizedMessage(), (Throwable)e1));
                }
                Activator.getDefault().getLog().log((IStatus)new Status(4, "fr.obeo.dsl.viewpoint.collab.user.profile", ERROR_MESSAGE + e.getLocalizedMessage(), (Throwable)e));
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return diagnostic;
    }

    private Diagnostic export(IProgressMonitor monitor, boolean userProfileModelResourceExists) throws IOException {
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        boolean exists = resourceSet.getURIConverter().exists(this.localUserProfileModelResourceURI, Collections.emptyMap());
        if (!exists) {
            diagnostic = new BasicDiagnostic(4, this.localUserProfileModelResourceURI.toString(), 0, "The local user profile model resource does not exists", null);
        } else {
            LifecycleState lifecycleState;
            Object previousConnector;
            Resource localUserProfileModelResource = resourceSet.getResource(this.localUserProfileModelResourceURI, true);
            CDOURIData remoteCDOURI = CDOURIDataHelper.createCDOURIData(this.remoteUserProfileModelResourceURI);
            String userName = null;
            char[] password = null;
            try {
                userName = URLDecoder.decode(remoteCDOURI.getUserName(), "UTF-8");
                password = URLDecoder.decode(remoteCDOURI.getPassWord(), "UTF-8").toCharArray();
            }
            catch (UnsupportedEncodingException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "fr.obeo.dsl.viewpoint.collab.user.profile", ERROR_MESSAGE + e.getLocalizedMessage(), (Throwable)e));
            }
            remoteCDOURI.setPassWord(null);
            remoteCDOURI.setUserName(null);
            URI uriWithoutCredential = remoteCDOURI.toURI();
            String description = String.valueOf(remoteCDOURI.getAuthority()) + "/" + remoteCDOURI.getRepositoryName();
            Object oldElement = null;
            try {
                oldElement = IPluginContainer.INSTANCE.getElement(GROUP_ID, PROPERTY_ID, description);
            }
            catch (FactoryNotFoundException factoryNotFoundException) {
                // empty catch block
            }
            IPluginContainer.INSTANCE.putElement(GROUP_ID, PROPERTY_ID, description, (Object)new PasswordCredentialsProvider(userName, password));
            String factoryType = this.getFactoryType(remoteCDOURI);
            Object object = previousConnector = factoryType == null ? null : IPluginContainer.INSTANCE.getElement("org.eclipse.net4j.connectors", factoryType, remoteCDOURI.getAuthority(), false);
            if (previousConnector != null && LifecycleState.INACTIVE == (lifecycleState = ((Connector)previousConnector).getLifecycleState())) {
                IPluginContainer.INSTANCE.removeElement("org.eclipse.net4j.connectors", factoryType, remoteCDOURI.getAuthority());
                previousConnector = null;
            }
            try {
                Resource remoteUserProfileModelResource;
                if (userProfileModelResourceExists) {
                    remoteUserProfileModelResource = resourceSet.getResource(uriWithoutCredential, true);
                    remoteUserProfileModelResource.getContents().clear();
                } else {
                    remoteUserProfileModelResource = resourceSet.createResource(uriWithoutCredential);
                }
                if (localUserProfileModelResource.getContents().size() != 1) {
                    diagnostic = new BasicDiagnostic(4, this.localUserProfileModelResourceURI.toString(), 0, "the local user profile model to export must have exactly one root element", null);
                } else if (!(localUserProfileModelResource.getContents().get(0) instanceof Realm)) {
                    diagnostic = new BasicDiagnostic(4, this.localUserProfileModelResourceURI.toString(), 0, "the local user profile model to export must have a Realm as root element", null);
                } else {
                    Realm realm = (Realm)localUserProfileModelResource.getContents().get(0);
                    diagnostic = Diagnostician.INSTANCE.validate((EObject)realm);
                    if (diagnostic.getSeverity() == 0) {
                        EcoreUtil.Copier copier = new EcoreUtil.Copier();
                        EObject realmCopy = copier.copy((EObject)realm);
                        remoteUserProfileModelResource.getContents().add((Object)realmCopy);
                        copier.copyReferences();
                        monitor.worked(1);
                        UserProfileUtil.addMissingTechnicalRoles((Realm)remoteUserProfileModelResource.getContents().get(0));
                        remoteUserProfileModelResource.save(Collections.singletonMap(CDOResource.OPTION_SAVE_PROGRESS_MONITOR, new SubProgressMonitor(monitor, 1)));
                    }
                }
                CDOResource cdoResource = (CDOResource)remoteUserProfileModelResource;
                CDOView cdoView = cdoResource.cdoView();
                cdoView.close();
                CDOSession session = cdoView.getSession();
                session.close();
            }
            finally {
                Object newConnector;
                IPluginContainer.INSTANCE.putElement(GROUP_ID, PROPERTY_ID, description, oldElement);
                if (factoryType != null && previousConnector == null && (newConnector = IPluginContainer.INSTANCE.getElement("org.eclipse.net4j.connectors", factoryType, remoteCDOURI.getAuthority(), false)) instanceof Connector) {
                    LifecycleState lifecycleState2 = ((Connector)newConnector).getLifecycleState();
                    if (LifecycleState.ACTIVE == lifecycleState2) {
                        LifecycleUtil.deactivate((Object)newConnector);
                    }
                    IPluginContainer.INSTANCE.removeElement("org.eclipse.net4j.connectors", factoryType, remoteCDOURI.getAuthority());
                }
            }
        }
        return diagnostic;
    }

    private String getFactoryType(CDOURIData remoteCDOURI) {
        String factoryType = null;
        if ("cdo.net4j.ws".equals(remoteCDOURI.getScheme())) {
            factoryType = "ws";
        } else if ("cdo.net4j.wss".equals(remoteCDOURI.getScheme())) {
            factoryType = "wss";
        }
        return factoryType;
    }
}

