/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.user.profile.internal.util;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.util.CDOURIData;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.common.util.URI;

public final class CDOURIDataHelper {
    private CDOURIDataHelper() {
    }

    public static CDOURIData createCDOURIData(URI uri) {
        CDOURIData remoteCDOURI = null;
        try {
            remoteCDOURI = new CDOURIData(uri);
            if ("cdo.net4j.ws".equals(remoteCDOURI.getScheme()) || "cdo.net4j.wss".equals(remoteCDOURI.getScheme())) {
                IPath path = new Path(remoteCDOURI.getRepositoryName()).append(remoteCDOURI.getResourcePath());
                int index = CDOURIDataHelper.getAcceptorSegmentIndex(path);
                if (index == -1) {
                    throw new InvalidURIException(uri);
                }
                String authority = remoteCDOURI.getAuthority();
                int j = 0;
                while (j <= index) {
                    authority = String.valueOf(authority) + "/" + path.segment(j);
                    ++j;
                }
                remoteCDOURI.setAuthority(authority);
                remoteCDOURI.setRepositoryName(path.segment(index + 1));
                remoteCDOURI.setResourcePath(path.removeFirstSegments(index + 2));
            }
        }
        catch (InvalidURIException e) {
            throw new InvalidURIException(URI.createURI((String)uri.toString().replaceAll(uri.userInfo(), "")));
        }
        return remoteCDOURI;
    }

    private static int getAcceptorSegmentIndex(IPath path) {
        int i = 0;
        while (i < path.segmentCount()) {
            if (path.segment(i).startsWith("@")) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

