/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.user.profile.manager;

import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorDelegate;
import fr.obeo.dsl.viewpoint.collab.user.profile.ConcreteObjectPermissionDerivedRefUpdaterInstaller;
import fr.obeo.dsl.viewpoint.collab.user.profile.UserProfileUtil;
import fr.obeo.dsl.viewpoint.collab.user.profile.manager.CollabUserProfileManagerConfig;
import java.util.Map;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.internal.security.SecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.view.CDOObjectHandler;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IAuthenticator2;

public class CollabUserProfileManager
extends SecurityManager
implements InternalSecurityManager {
    protected CollabUserProfileManagerConfig config;
    protected IAuthenticator delegateAuthenticator;
    private ConcreteObjectPermissionDerivedRefUpdaterInstaller concreteObjectPermissionDerivedRefUpdaterInstaller;

    public CollabUserProfileManager(CollabUserProfileManagerConfig config, IManagedContainer container) {
        super(config.getRealmUsersPath(), container);
        this.config = config;
    }

    protected void init() {
        super.init();
        IAuthenticatorConfig authenticatorConfig = this.config.getAuthenticatorDelegateConfig();
        if (authenticatorConfig != null) {
            this.delegateAuthenticator = authenticatorConfig.instanciateAuthenticator();
            CollabUserProfileAuthenticator authenticator = new CollabUserProfileAuthenticator(this.delegateAuthenticator);
            ISessionManager sessionManager = this.getRepository().getSessionManager();
            if (sessionManager != null) {
                sessionManager.setAuthenticator((IAuthenticator)authenticator);
            }
        }
        if (this.getRealm() != null) {
            this.concreteObjectPermissionDerivedRefUpdaterInstaller = new ConcreteObjectPermissionDerivedRefUpdaterInstaller();
            this.getRealm().cdoView().addObjectHandler((CDOObjectHandler)this.concreteObjectPermissionDerivedRefUpdaterInstaller);
        }
    }

    protected Realm createRealm() {
        Realm realm = SecurityFactory.eINSTANCE.createRealm("User Profile Realm");
        if (this.config.getAdministrators() != null && !this.config.getAdministrators().isEmpty()) {
            for (Map.Entry<String, String> entry : this.config.getAdministrators().entrySet()) {
                User adminUser = realm.addUser(entry.getKey(), entry.getValue());
                adminUser.setDefaultAccessOverride(Access.WRITE);
            }
        } else {
            User adminUser = realm.addUser("Administrator", "0000");
            adminUser.setDefaultAccessOverride(Access.WRITE);
        }
        UserProfileUtil.initializeRoles(realm, this.config.getPermissionSemanticFileExtensions());
        UserProfileUtil.addMissingTechnicalRoles(realm);
        return realm;
    }

    protected class CollabUserProfileAuthenticator
    implements IAuthenticator2,
    IAuthenticatorDelegate {
        private IAuthenticator delegateAuthenticator;

        protected CollabUserProfileAuthenticator(IAuthenticator delegateAuthenticator) {
            this.delegateAuthenticator = delegateAuthenticator;
        }

        public void authenticate(String userID, char[] password) throws SecurityException {
            Realm realm = CollabUserProfileManager.this.getRealm();
            if (realm != null && realm.getUser(userID) == null) {
                throw new SecurityException("User " + userID + " not found");
            }
            if (this.delegateAuthenticator != null) {
                this.delegateAuthenticator.authenticate(userID, password);
            }
        }

        public boolean isAdministrator(String userID) {
            Realm realm = CollabUserProfileManager.this.getRealm();
            if (realm != null) {
                User user = realm.getUser(userID);
                return user != null && CollabUserProfileManager.this.isAdministrator(user);
            }
            return false;
        }

        public void updatePassword(String userID, char[] oldPassword, char[] newPassword) {
            if (this.delegateAuthenticator instanceof IAuthenticator2) {
                ((IAuthenticator2)this.delegateAuthenticator).updatePassword(userID, oldPassword, newPassword);
            }
            throw new UnsupportedOperationException();
        }

        public void resetPassword(String adminID, char[] adminPassword, String userID, char[] newPassword) {
            if (this.delegateAuthenticator instanceof IAuthenticator2) {
                ((IAuthenticator2)this.delegateAuthenticator).resetPassword(adminID, adminPassword, userID, newPassword);
            }
            throw new UnsupportedOperationException();
        }

        public IAuthenticator getAuthenticator() {
            return this.delegateAuthenticator;
        }
    }
}

