/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.oo15oo.oo179oo.oo6083oo;

import com.google.common.base.Joiner;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public final class Oo43289oo {
    private final Collection<String> errors = new ArrayList<String>();
    private int nbFree = 0;
    private int nbTokens = 0;
    public static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private Date oo19805oo;
    private final Collection<TokenInfo> tokenInfos = new ArrayList<TokenInfo>();

    public Oo43289oo() {
        this.oo19805oo = new Date();
    }

    void addError(String message) {
        this.errors.add("\"" + message + "\"");
    }

    void addFreeToken() {
        ++this.nbFree;
    }

    void addToken() {
        ++this.nbTokens;
    }

    void addTokenInfo(String macAddresses, Long oo19805oo, String inetAddr, String userName) {
        TokenInfo oo134oo = new TokenInfo();
        oo134oo.macAddresses = macAddresses;
        oo134oo.lastSeen = oo19805oo;
        oo134oo.inetAddr = inetAddr;
        oo134oo.userName = userName;
        this.tokenInfos.add(oo134oo);
    }

    public Collection<String> getErrors() {
        return this.errors;
    }

    public int getNbFree() {
        return this.nbFree;
    }

    public int getNbTokens() {
        return this.nbTokens;
    }

    public Collection<String> getTokenInfos() {
        ArrayList<String> jsonTokenInfo = new ArrayList<String>();
        for (TokenInfo i : this.tokenInfos) {
            StringBuffer statusLine = new StringBuffer();
            statusLine.append("{");
            statusLine.append("\"user\":");
            statusLine.append("\"" + i.macAddresses + "\"");
            statusLine.append(',');
            statusLine.append("\"lastSeen\":");
            Date resultdate = new Date(i.lastSeen);
            statusLine.append("\"" + sdf.format(resultdate) + "\"");
            statusLine.append(',');
            statusLine.append("\"ip:\":");
            statusLine.append("\"" + i.inetAddr + "\"");
            statusLine.append(',');
            statusLine.append("\"userName:\":");
            statusLine.append("\"" + i.userName + "\"");
            statusLine.append("}");
            jsonTokenInfo.add(statusLine.toString());
        }
        return jsonTokenInfo;
    }

    public String toJsonReport() {
        StringBuffer oo29oo = new StringBuffer();
        oo29oo.append("{");
        oo29oo.append("\n     \"total\": " + this.nbTokens + ",\n");
        oo29oo.append("     \"free\":" + this.nbFree + ",\n");
        oo29oo.append("     \"used\":\n            [\n         ");
        oo29oo.append(Joiner.on((String)",\n         ").join(this.getTokenInfos()));
        oo29oo.append("\n            ],\n");
        oo29oo.append("     \"errors\":[");
        oo29oo.append(Joiner.on((String)",\n").join(this.errors));
        oo29oo.append("]\n");
        oo29oo.append("   }");
        return oo29oo.toString();
    }

    public String toString() {
        return this.toJsonReport();
    }

    public String toHTMLReport() {
        StringBuffer result = new StringBuffer();
        if (this.errors.size() > 0) {
            result.append("<p class=\" red accent-1\"> Errors:");
            result.append(Joiner.on((String)"<br>").join(this.errors));
            result.append("</p>");
        }
        result.append("<p>Last updated at: " + sdf.format(this.oo19805oo) + "</p>");
        result.append("<p>Total: <span>" + this.nbTokens + "</span></p>");
        result.append("<p>Free: <span>" + this.nbFree + "</span></p>");
        ArrayList<String> htmlTokenInfo = new ArrayList<String>();
        for (TokenInfo i : this.tokenInfos) {
            Date resultdate = new Date(i.lastSeen);
            htmlTokenInfo.add("<tr><td>" + i.userName + "</td><td>" + sdf.format(resultdate) + "</td><td>" + i.inetAddr + "</td><td>" + i.macAddresses + "</td></tr>");
        }
        result.append("<p>Used: <span>" + htmlTokenInfo.size() + "</span></p>");
        result.append("<table><thead><tr><th>User Name</th><th>Last seen</th><th>IP Address</th><th>MAC Address(es)</th></thead><tbody>");
        result.append(Joiner.on((String)"\n").join(htmlTokenInfo));
        result.append("</tbody></table>");
        return result.toString();
    }

    public Date getTimestamp() {
        return this.oo19805oo;
    }

    class TokenInfo {
        public Long lastSeen;
        public String macAddresses;
        public String inetAddr;
        public String userName;

        TokenInfo() {
        }
    }
}

