/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.connector.ConnectorState;
import org.eclipse.net4j.internal.tcp.ControlChannel;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.internal.tcp.messages.Messages;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.tcp.ITCPActiveSelectorListener;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.tcp.ITCPNegotiationContext;
import org.eclipse.net4j.tcp.ITCPSelector;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.RoundRobinBlockingQueue;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.NegotiationContext;
import org.eclipse.net4j.util.security.NegotiationException;
import org.eclipse.spi.net4j.Connector;
import org.eclipse.spi.net4j.InternalChannel;

public abstract class TCPConnector
extends Connector
implements ITCPConnector,
ITCPActiveSelectorListener {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, TCPConnector.class);
    private SocketChannel socketChannel;
    private ITCPSelector selector;
    @ReflectUtil.ExcludeFromDump
    private SelectionKey selectionKey;
    private BlockingQueue<InternalChannel> writeQueue = new RoundRobinBlockingQueue();
    private IBuffer inputBuffer;
    private ControlChannel controlChannel;
    private String host;
    private int port;

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public ITCPSelector getSelector() {
        return this.selector;
    }

    public void setSelector(ITCPSelector selector) {
        this.selector = selector;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    public void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    public BlockingQueue<InternalChannel> getWriteQueue() {
        return this.writeQueue;
    }

    public void setWriteQueue(BlockingQueue<InternalChannel> writeQueue) {
        this.writeQueue = writeQueue;
    }

    public IBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public void setInputBuffer(IBuffer inputBuffer) {
        this.inputBuffer = inputBuffer;
    }

    public ControlChannel getControlChannel() {
        return this.controlChannel;
    }

    public void setControlChannel(ControlChannel controlChannel) {
        this.controlChannel = controlChannel;
    }

    public String getURL() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getProtocolString());
        builder.append(this.host);
        builder.append(":");
        builder.append(this.port);
        return builder.toString();
    }

    public String getProtocolString() {
        return "tcp://";
    }

    @Override
    public void handleRegistration(ITCPSelector selector, SocketChannel socketChannel) {
        try {
            int interest = this.isClient() ? 8 : 1;
            this.selectionKey = socketChannel.register(selector.getSocketSelector(), interest, this);
            if (this.isServer()) {
                this.leaveConnecting();
            }
        }
        catch (Exception ex) {
            this.deferredActivate(false);
        }
    }

    @Override
    public void handleConnect(ITCPSelector selector, SocketChannel channel) {
        try {
            if (channel.finishConnect()) {
                selector.orderConnectInterest(this.selectionKey, true, false);
                selector.orderReadInterest(this.selectionKey, true, true);
                this.leaveConnecting();
            }
        }
        catch (Exception ex) {
            this.deferredActivate(false);
        }
    }

    @Override
    public void handleRead(ITCPSelector selector, SocketChannel socketChannel) {
        block10: {
            try {
                ByteBuffer byteBuffer;
                if (this.inputBuffer == null) {
                    this.inputBuffer = this.getConfig().getBufferProvider().provideBuffer();
                }
                if ((byteBuffer = this.inputBuffer.startGetting(socketChannel)) != null) {
                    ControlChannel channel;
                    short channelID = this.inputBuffer.getChannelID();
                    ControlChannel controlChannel = channel = channelID == 0 ? this.controlChannel : this.getChannel(channelID);
                    if (channel != null) {
                        channel.handleBufferFromMultiplexer(this.inputBuffer);
                    } else {
                        if (TRACER.isEnabled()) {
                            TRACER.trace("Discarding buffer from unknown channel");
                        }
                        this.inputBuffer.release();
                    }
                    this.inputBuffer = null;
                }
            }
            catch (NegotiationException ex) {
                OM.LOG.error((Throwable)ex);
                this.setNegotiationException(ex);
                this.deactivateAsync();
            }
            catch (ClosedChannelException ex) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Socket channel closed: " + socketChannel);
                }
                this.deactivateAsync();
            }
            catch (Exception ex) {
                if (!this.isActive()) break block10;
                OM.LOG.error((Throwable)ex);
                this.deactivateAsync();
            }
        }
    }

    public void handleRead2(ITCPSelector selector, SocketChannel socketChannel) throws ClosedChannelException {
        block10: {
            try {
                ByteBuffer byteBuffer;
                if (this.inputBuffer == null) {
                    this.inputBuffer = this.getConfig().getBufferProvider().provideBuffer();
                }
                if ((byteBuffer = this.inputBuffer.startGetting(socketChannel)) != null) {
                    ControlChannel channel;
                    short channelID = this.inputBuffer.getChannelID();
                    ControlChannel controlChannel = channel = channelID == 0 ? this.controlChannel : this.getChannel(channelID);
                    if (channel != null) {
                        channel.handleBufferFromMultiplexer(this.inputBuffer);
                    } else {
                        if (TRACER.isEnabled()) {
                            TRACER.trace("Discarding buffer from unknown channel");
                        }
                        this.inputBuffer.release();
                    }
                    this.inputBuffer = null;
                }
            }
            catch (NegotiationException ex) {
                OM.LOG.error((Throwable)ex);
                this.setNegotiationException(ex);
                this.deactivateAsync();
            }
            catch (ClosedChannelException ex) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Socket channel closed: " + socketChannel);
                }
                this.deactivateAsync();
                throw ex;
            }
            catch (Exception ex) {
                if (!this.isActive()) break block10;
                OM.LOG.error((Throwable)ex);
                this.deactivateAsync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiplexChannel(InternalChannel channel) {
        BlockingQueue<InternalChannel> blockingQueue = this.writeQueue;
        synchronized (blockingQueue) {
            boolean firstChannel = this.writeQueue.isEmpty();
            try {
                this.writeQueue.put(channel);
            }
            catch (InterruptedException ex) {
                throw WrappedException.wrap((Exception)ex);
            }
            if (firstChannel && this.selectionKey != null) {
                this.doOrderWriteInterest(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleWrite(ITCPSelector selector, SocketChannel socketChannel) {
        block11: {
            try {
                BlockingQueue<InternalChannel> blockingQueue = this.writeQueue;
                synchronized (blockingQueue) {
                    IBuffer buffer;
                    Queue channelSendQueue;
                    InternalChannel channel = (InternalChannel)this.writeQueue.peek();
                    if (channel != null && (channelSendQueue = channel.getSendQueue()) != null && (buffer = (IBuffer)channelSendQueue.peek()) != null && buffer.write(socketChannel)) {
                        this.writeQueue.poll();
                        channelSendQueue.poll();
                        boolean closeChannelAfterMe = buffer.isCCAM();
                        buffer.release();
                        if (closeChannelAfterMe) {
                            channel.close();
                        }
                    }
                    if (this.writeQueue.isEmpty() && this.selectionKey != null) {
                        this.doOrderWriteInterest(false);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ClosedChannelException ex) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Socket channel closed: " + socketChannel);
                }
                this.deactivateAsync();
            }
            catch (Exception ex) {
                if (!this.isActive()) break block11;
                OM.LOG.error((Throwable)ex);
                this.deactivateAsync();
            }
        }
    }

    protected void doOrderWriteInterest(boolean on) {
        this.selector.orderWriteInterest(this.selectionKey, this.isClient(), on);
    }

    protected void registerChannelWithPeer(short channelID, long timeout, IProtocol<?> protocol) throws ChannelException {
        this.controlChannel.registerChannel(channelID, timeout, protocol);
    }

    protected void deregisterChannelFromPeer(InternalChannel channel) throws ChannelException {
        if (channel != null && channel.getClass() != ControlChannel.class && this.controlChannel != null && this.isConnected()) {
            this.controlChannel.deregisterChannel(channel.getID());
        }
    }

    protected INegotiationContext createNegotiationContext() {
        return new TCPNegotiationContext();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.socketChannel == null) {
            throw new IllegalStateException("socketChannel == null");
        }
        if (this.selector == null) {
            throw new IllegalStateException("selector == null");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.controlChannel = new ControlChannel(this);
        this.controlChannel.activate();
        this.selector.orderRegistration(this.socketChannel, this.isClient(), this);
    }

    protected void doDeactivate() throws Exception {
        this.cancelSelectionKey();
        LifecycleUtil.deactivate((Object)((Object)this.controlChannel));
        this.controlChannel = null;
        IOUtil.closeSilent((Closeable)this.socketChannel);
        this.socketChannel = null;
        super.doDeactivate();
    }

    protected void deactivateAsync() {
        this.cancelSelectionKey();
        this.getConfig().getReceiveExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TCPConnector.this.deactivate();
            }
        });
    }

    private void cancelSelectionKey() {
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
            this.selectionKey = null;
        }
    }

    private final class TCPNegotiationContext
    extends NegotiationContext
    implements ITCPNegotiationContext {
        private IBuffer buffer;
        private boolean failed;

        @Override
        public TCPConnector getConnector() {
            return TCPConnector.this;
        }

        public void setUserID(String userID) {
            TCPConnector.this.setUserID(userID);
        }

        public ByteBuffer getBuffer() {
            this.buffer = TCPConnector.this.getConfig().getBufferProvider().provideBuffer();
            ByteBuffer byteBuffer = this.buffer.startPutting((short)0);
            byteBuffer.put((byte)1);
            return byteBuffer;
        }

        public void transmitBuffer(ByteBuffer byteBuffer) {
            if (this.buffer.getByteBuffer() != byteBuffer) {
                throw new IllegalArgumentException("The passed buffer is not the last that was produced");
            }
            TCPConnector.this.controlChannel.sendBuffer(this.buffer);
            if (this.failed) {
                TCPConnector.this.deactivate();
            }
        }

        public void setFinished(boolean success) {
            if (success) {
                TCPConnector.this.setState(ConnectorState.CONNECTED);
            } else {
                OM.LOG.error(String.valueOf(Messages.getString("TCPConnector.6")) + TCPConnector.this);
                this.failed = true;
            }
            super.setFinished(success);
        }
    }
}

