/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.adm.services.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtils {
    public static long getDirSize(File dir) throws Exception {
        long size = 0L;
        if (dir.isFile()) {
            size = dir.length();
        } else {
            File[] subFiles;
            File[] fileArray = subFiles = dir.listFiles();
            int n = subFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                size = file.isFile() ? (size += file.length()) : (size += FileUtils.getDirSize(file));
                ++n2;
            }
        }
        return size;
    }

    public static File folder(String folderName) {
        if (folderName == null || folderName.isEmpty()) {
            return null;
        }
        return new File(folderName);
    }

    public static long folderMaxSize(String propertyValue) {
        long value = 0L;
        if (propertyValue == null || propertyValue.isEmpty()) {
            return value;
        }
        Pattern p = Pattern.compile("^([0-9]+)([obkmgOBKMG])?([obOB])?");
        Matcher m = p.matcher(propertyValue);
        if (m.find()) {
            String unit = null;
            if (m.group(2) != null) {
                unit = m.group(2).toLowerCase();
            }
            value = Long.valueOf(m.group(1));
            value = (long)((double)(value * (long)("k".equals(unit) ? 1024 : 1)) * ("m".equals(unit) ? Math.pow(1024.0, 2.0) : 1.0) * ("g".equals(unit) ? Math.pow(1024.0, 3.0) : 1.0));
        }
        return value;
    }

    public static byte[] createChecksum(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(file);){
            Throwable throwable2 = null;
            Object var6_8 = null;
            try {
                DigestInputStream is2 = new DigestInputStream(is, md);
                if (is2 != null) {
                    ((InputStream)is2).close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return md.digest();
    }

    public static String getMD5Checksum(File file) throws Exception {
        byte[] b = FileUtils.createChecksum(file);
        String result = "";
        byte[] byArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            result = String.valueOf(result) + Integer.toString((element & 0xFF) + 256, 16).substring(1);
            ++n2;
        }
        return result;
    }
}

