/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.NewSharedModelingProject;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.SimpleUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.server.IRepository;

public abstract class AbstractRepositoryManager
implements IRepositoryManager {
    @Override
    public IStatus preStart(RepositoryData repositoryData) {
        this.logTask("Pre-start", repositoryData);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus postStart(RepositoryData repositoryData) {
        this.logTask("Post-start", repositoryData);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus preStop(RepositoryData repositoryData) {
        this.logTask("Pre-stop", repositoryData);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus postStop(RepositoryData repositoryData) {
        this.logTask("Post-stop", repositoryData);
        return Status.OK_STATUS;
    }

    protected void logTask(String taskName, RepositoryData repositoryData) {
        String key;
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty(taskName)) {
            sb.append(taskName);
            sb.append(": ");
        }
        if (repositoryData != null && !StringUtil.isEmpty(repositoryData.getRepositoryName())) {
            sb.append(repositoryData.getRepositoryName());
        }
        if (!StringUtil.isEmpty(key = this.getKey())) {
            sb.append(" - ").append(key);
        }
        OM.LOG.info(sb.toString());
    }

    @Override
    public List<SimpleUser> getAllUsers(String repositoryName) {
        return Collections.emptyList();
    }

    @Override
    public IStatus createUser(RepositoryData repositoryData, NewUser newUser) {
        return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("No repository manager has been found for the key %1$s.", repositoryData.getAuthenticationType()));
    }

    @Override
    public IStatus deleteUser(RepositoryData repositoryData, String username) {
        return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("No repository manager has been found for the key %1$s.", repositoryData.getAuthenticationType()));
    }

    @Override
    public Optional<IRepository> prepareRepositoryForImport(RepositoryData repositoryData) {
        return Optional.empty();
    }

    @Override
    public IStatus postSharedModelingProjectCreation(NewSharedModelingProject project) {
        return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", "The data are invalid.");
    }
}

