/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.repository;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.PathParamReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;

public class RepositoryResource
extends HttpServlet {
    public static final String ALIAS = "/api/v1.0/repositories/*";
    private static final String DELETE_DATABASE_QUERY_PARAMETER = "deleteDatabase";
    private static final int REPOSITORYNAME_PATH_INFO_POSITION = 0;
    private static final long serialVersionUID = -2011141950251386341L;
    private static final String ERROR_MESSAGE = "The repository %1$s has not been deleted.";

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AbstractResponse response = null;
        String repositoryName = new PathParamReader(req).getPathSegment(0);
        boolean deleteDatabase = Optional.ofNullable(req.getParameter(DELETE_DATABASE_QUERY_PARAMETER)).map(Boolean::parseBoolean).orElse(Boolean.TRUE);
        String validatedRepositoryName = AdminServletValidator.validateRepositoryName(repositoryName);
        if ("NO_ISSUE_DIAGNOSTIC".equals(validatedRepositoryName)) {
            String validatedRepository = AdminServletValidator.validateRepository(repositoryName, AdminServletValidator.RequiredRepositoryStatus.NONE);
            if ("NO_ISSUE_DIAGNOSTIC".equals(validatedRepository)) {
                IStatus status = CDORepositoryUtil.deleteRepository(repositoryName);
                if (status.isOK()) {
                    response = ResponseFactory.createDeletedRepositoryResponse(repositoryName, deleteDatabase);
                } else {
                    StringBuilder messageBuilder = new StringBuilder("Something happens during the repository deletion: ");
                    messageBuilder.append(status.getMessage());
                    if (status.getException() != null) {
                        messageBuilder.append("\nException: ").append(status.getException().getMessage());
                    }
                    response = ResponseFactory.createInternalServerErrorResponse(String.format(ERROR_MESSAGE, repositoryName), messageBuilder.toString());
                }
            } else {
                response = ResponseFactory.createNotFoundErrorResponse(String.format(ERROR_MESSAGE, repositoryName), validatedRepository);
            }
        } else {
            response = ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), validatedRepositoryName);
        }
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), (Object)response);
    }
}

