/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.PathParamReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.ExportRepository;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExportRepositoryResource
extends HttpServlet {
    public static final String ALIAS = "/api/v1.0/repositories/export/*";
    public static final String EXPORT_RESULT_SEGMENT = "/api/v1.0/exports/repositories/";
    public static final String EXPORT_RESULT_ALIAS = "/api/v1.0/exports/repositories/*";
    private static final long serialVersionUID = 875430994568513258L;
    private static final int REPOSITORYNAME_PATH_INFO_POSITION = 0;
    private static final String ERROR_MESSAGE = "The repository %1$s will not be exported.";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String repositoryReadyForExportDiagnostic;
        String repositoryExistsDiagnostic;
        String repositoryName = new PathParamReader(req).getPathSegment(0);
        ExportRepository exportRepository = JsonBodyReader.read((ServletRequest)req, ExportRepository.class);
        boolean needsEncryption = exportRepository.needsEncryption();
        String password = exportRepository.getPassword();
        AbstractResponse response = null;
        String repositoryNameDiagnostic = AdminServletValidator.validateRepositoryName(repositoryName);
        response = "NO_ISSUE_DIAGNOSTIC".equals(repositoryNameDiagnostic) ? ("NO_ISSUE_DIAGNOSTIC".equals(repositoryExistsDiagnostic = AdminServletValidator.validateRepositoryExists(repositoryName)) ? ("NO_ISSUE_DIAGNOSTIC".equals(repositoryReadyForExportDiagnostic = AdminServletValidator.validateRepositoryReadyForExport(repositoryName, needsEncryption, password, AdminServletValidator.RequiredRepositoryStatus.STARTED)) ? this.doExportRepository(repositoryName, req.getScheme(), req.getServerName(), req.getServerPort(), needsEncryption, password) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryNameDiagnostic)) : ResponseFactory.createNotFoundErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryExistsDiagnostic)) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryNameDiagnostic);
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), (Object)response);
    }

    private AbstractResponse doExportRepository(String repositoryName, String protocol, String host, int port, boolean needsEncryption, String password) {
        AbstractResponse response = null;
        try {
            String url = CDORepositoryUtil.exportRepository(repositoryName, protocol, host, port, needsEncryption, password);
            response = ResponseFactory.createExportedRepositoryResponse(repositoryName, url);
        }
        catch (IOException e) {
            response = ResponseFactory.createInternalServerErrorResponse(String.format(ERROR_MESSAGE, repositoryName), e.getLocalizedMessage());
        }
        return response;
    }

    public static Path getExportResultResourceRoot() {
        return Paths.get(AdminServerConfigurationHelper.getInstance().getRepositoriesExportDirectoryPath(), "exports");
    }
}

