/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.PathParamReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.net4j.util.io.IOUtil;

public class ImportRepositoryResource
extends HttpServlet {
    public static final String ALIAS = "/api/v1.0/repositories/import/*";
    private static final long serialVersionUID = -9059560965434868703L;
    private static final String ERROR_MESSAGE = "The import of the repository %1$s will not be launched.";
    private static final int REPOSITORYNAME_PATH_INFO_POSITION = 0;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String repositoryReadyForImportDiagnostic;
        String repositoryExistsDiagnostic;
        String repositoryName = new PathParamReader(req).getPathSegment(0);
        Collection parts = req.getParts();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Part part : parts) {
            IOUtil.copy((InputStream)part.getInputStream(), (OutputStream)baos);
        }
        byte[] bytesToImport = baos.toByteArray();
        AbstractResponse response = null;
        String repositoryNameDiagnostic = AdminServletValidator.validateRepositoryName(repositoryName);
        response = "NO_ISSUE_DIAGNOSTIC".equals(repositoryNameDiagnostic) ? ("NO_ISSUE_DIAGNOSTIC".equals(repositoryExistsDiagnostic = AdminServletValidator.validateRepositoryExists(repositoryName)) ? ("NO_ISSUE_DIAGNOSTIC".equals(repositoryReadyForImportDiagnostic = AdminServletValidator.validateRepositoryReadyForImport(repositoryName, bytesToImport)) ? this.doImportRepository(repositoryName, bytesToImport) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryReadyForImportDiagnostic)) : ResponseFactory.createNotFoundErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryExistsDiagnostic)) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryNameDiagnostic);
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), (Object)response);
    }

    private AbstractResponse doImportRepository(String repositoryName, byte[] bytesToImport) {
        CDORepositoryUtil.importToRepository(repositoryName, bytesToImport);
        return ResponseFactory.createImportRepositoryResponse(repositoryName);
    }
}

