/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.PathParamReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.Repository;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDOServerConfigFileUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;

public class StopRepositoryResource
extends HttpServlet {
    public static final String ALIAS = "/api/v1.0/repositories/stop/*";
    private static final String ERROR_MESSAGE = "The repository %1$s has not been stopped.";
    private static final int REPOSITORYNAME_PATH_INFO_POSITION = 0;
    private static final long serialVersionUID = 7251142897693844766L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AbstractResponse response = null;
        String repositoryName = new PathParamReader(req).getPathSegment(0);
        String repositoryNameDiagnostic = AdminServletValidator.validateRepositoryName(repositoryName);
        if ("NO_ISSUE_DIAGNOSTIC".equals(repositoryNameDiagnostic)) {
            String repositoryExistsDiagnostic = AdminServletValidator.validateRepositoryExists(repositoryName);
            if ("NO_ISSUE_DIAGNOSTIC".equals(repositoryExistsDiagnostic)) {
                String repositoryStatusDiagnostic = AdminServletValidator.validateRepositoryStatus(repositoryName, AdminServletValidator.RequiredRepositoryStatus.STARTED);
                if ("NO_ISSUE_DIAGNOSTIC".equals(repositoryStatusDiagnostic)) {
                    IStatus status = CDORepositoryUtil.stopRepository(repositoryName);
                    if (status.isOK()) {
                        Repository repository = new Repository();
                        repository.setName(repositoryName);
                        repository.setStatus("OFFLINE");
                        boolean repositoryStatic = CDOServerConfigFileUtil.getInstance().isRepositoryStatic(repositoryName);
                        repository.setType(repositoryStatic ? Repository.RepositoryType.STATIC : Repository.RepositoryType.DYNAMIC);
                        response = ResponseFactory.createRepositoryStoppedResponse(repository);
                    } else {
                        response = this.buildErrorMessage(repositoryName, status);
                    }
                } else {
                    response = ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryStatusDiagnostic);
                }
            } else {
                response = ResponseFactory.createNotFoundErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryExistsDiagnostic);
            }
        } else {
            response = ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryNameDiagnostic);
        }
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), (Object)response);
    }

    private AbstractResponse buildErrorMessage(String repositoryName, IStatus status) {
        StringBuilder messageBuilder = new StringBuilder("An error occurred while stopping the repository: ");
        if (status != null) {
            messageBuilder.append(status.getMessage());
            if (status.getException() != null) {
                messageBuilder.append(status.getException().getMessage());
            }
        }
        return ResponseFactory.createInternalServerErrorResponse(String.format(ERROR_MESSAGE, repositoryName), messageBuilder.toString());
    }
}

