/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.user;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.Repository;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.SimpleUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;

public class UsersResource
extends HttpServlet {
    public static final String ALIAS = "/api/v1.0/users";
    private static final String ERROR_MESSAGE = "The user %1$s cannot be created.";
    private static final String LIST_USER_ERROR_MESSAGE = "Users cannot be listed on repository %1$s.";
    private static final String REPOSITORY_NAME_QUERY_PARAMETER = "repositoryName";
    private static final long serialVersionUID = 4301934803691193525L;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String repositoryName = req.getParameter(REPOSITORY_NAME_QUERY_PARAMETER);
        NewUser newUser = JsonBodyReader.read((ServletRequest)req, NewUser.class);
        AbstractResponse response = null;
        String newUserDiagnostic = AdminServletValidator.validate(newUser, repositoryName);
        response = "NO_ISSUE_DIAGNOSTIC".equals(newUserDiagnostic) ? this.doCreateUser(repositoryName, newUser) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, newUser.getId()), newUserDiagnostic);
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), (Object)response);
    }

    private AbstractResponse doCreateUser(String repositoryName, NewUser newUser) {
        AbstractResponse response = null;
        IStatus status = CDORepositoryUtil.createUser(repositoryName, newUser);
        response = status.isOK() ? CDORepositoryUtil.getUser(repositoryName, newUser.getId()).map(user -> ResponseFactory.createNewUserResponse(user, repositoryName)).map(AbstractResponse.class::cast).orElseGet(() -> this.buildErrorResponse(newUser, null)) : this.buildErrorResponse(newUser, status);
        return response;
    }

    private AbstractResponse buildErrorResponse(NewUser newUser, IStatus status) {
        StringBuilder messageBuilder = new StringBuilder("An error occurred while creating the user");
        if (status != null) {
            messageBuilder.append(": ");
            messageBuilder.append(status.getMessage());
            if (status.getException() != null) {
                messageBuilder.append("\nException: ").append(status.getException().getMessage());
            }
        } else {
            messageBuilder.append(".");
        }
        return ResponseFactory.createInternalServerErrorResponse(String.format(ERROR_MESSAGE, newUser.getId()), messageBuilder.toString());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String repositoryName = req.getParameter(REPOSITORY_NAME_QUERY_PARAMETER);
        AbstractResponse response = null;
        String repositoryReadyForOperationDiagnostic = AdminServletValidator.validateRepositoryReadyForOperation(repositoryName);
        if ("NO_ISSUE_DIAGNOSTIC".equals(repositoryReadyForOperationDiagnostic)) {
            Optional<Repository> repository = CDORepositoryUtil.getRepository(repositoryName);
            if (repository.isPresent() && Repository.RepositoryType.STATIC.equals((Object)repository.get().getType())) {
                response = ResponseFactory.createBadRequestErrorResponse(String.format(LIST_USER_ERROR_MESSAGE, repositoryName), "Static repository not managed on this service.");
            } else {
                List<SimpleUser> allUsers = CDORepositoryUtil.getAllUsers(repositoryName);
                response = ResponseFactory.createGetUsersResponse(allUsers, repositoryName);
            }
        } else {
            response = ResponseFactory.createBadRequestErrorResponse(String.format(LIST_USER_ERROR_MESSAGE, repositoryName), repositoryReadyForOperationDiagnostic);
        }
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), (Object)response);
    }
}

