/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AbstractRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.NewSharedModelingProject;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.SimpleUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.UserUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.CDOTransactionHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.spi.server.IAppExtension;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserProfileRepositoryManager
extends AbstractRepositoryManager
implements IRepositoryManager {
    protected static final String REALM_PATH_XML_TAG_ATTRIBUTE = "realmPath";
    protected static final String TYPE_XML_TAG_ATTRIBUTE = "type";
    protected static final String SECURITY_MANAGER_XML_TAG = "securityManager";
    protected static final String USERPROFILE_CONFIG_PROPERTIES_FILE = "userprofile-config.properties";
    private static final String KEY = "USERPROFILE";
    private static final String CDO_SERVER_INTERNAL_SECURITY_EXTENSION = "org.eclipse.emf.cdo.server.internal.security.SecurityExtension";
    private static final String ROLES_CREATION_ERROR_MESSAGE = "Permissions have not been created, please refer to the Administrator Manual to configure permissions.";
    private static final SecurityFactory SF = SecurityFactory.eINSTANCE;

    @Override
    public void manage(Document document, Element parentElement, RepositoryData repositoryData) {
        String propertiesFilePath = this.createPropertiesFile(repositoryData);
        Element element = document.createElement(SECURITY_MANAGER_XML_TAG);
        element.setAttribute(TYPE_XML_TAG_ATTRIBUTE, "collab_web_services");
        element.setAttribute(REALM_PATH_XML_TAG_ATTRIBUTE, propertiesFilePath);
        parentElement.appendChild(element);
    }

    protected String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        Map<String, Object> authenticationData = repositoryData.getAuthenticationData();
        String userProfileConfigurationFilePath = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + USERPROFILE_CONFIG_PROPERTIES_FILE;
        String administratorsPropertiesFile = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + "administrator.properties";
        try {
            Map<String, String> adminProperties = CDORepositoryUtil.convertCredentialsToProperties((ArrayList)authenticationData.get("administrators"));
            CommonUtil.createProperiesFileFromMap(administratorsPropertiesFile, adminProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The administrator properties file (%1$s) has not been created", administratorsPropertiesFile), (Throwable)e);
        }
        LinkedHashMap<String, String> userProfileProperties = new LinkedHashMap<String, String>();
        userProfileProperties.put("realm.users.path", "users.userprofile");
        userProfileProperties.put("administrators.file.path", administratorsPropertiesFile);
        try {
            CommonUtil.createProperiesFileFromMap(userProfileConfigurationFilePath, userProfileProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The user profile configuration properties file (%1$s) has not been created", userProfileConfigurationFilePath), (Throwable)e);
        }
        return userProfileConfigurationFilePath;
    }

    @Override
    public IStatus postStart(RepositoryData repositoryData) {
        IConfigurationElement[] elements;
        IStatus status = Status.OK_STATUS;
        String repositoryName = repositoryData.getRepositoryName();
        Path configFilePath = Paths.get(repositoryData.getConfigurationFolderPath(), repositoryName, String.valueOf(repositoryName) + ".xml");
        File configFile = configFilePath.toFile();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server", "appExtensions");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("appExtension".equals(element.getName()) && CDO_SERVER_INTERNAL_SECURITY_EXTENSION.equals(element.getAttribute("class"))) {
                try {
                    IAppExtension extension = (IAppExtension)element.createExecutableExtension("class");
                    extension.start(configFile);
                }
                catch (Exception e) {
                    String error = "The security extension has not been started";
                    OM.LOG.error(error, (Throwable)e);
                    status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", error, (Throwable)e);
                }
            }
            ++n2;
        }
        super.postStart(repositoryData);
        return status;
    }

    @Override
    public List<SimpleUser> getAllUsers(String repositoryName) {
        ArrayList<SimpleUser> users = new ArrayList<SimpleUser>();
        Optional<InternalRepository> optionalRepository = CDORepositoryUtil.getRepositoryFromName(repositoryName);
        Stream usersStream = optionalRepository.map(SecurityManagerUtil::getSecurityManager).map(ISecurityManager::getRealm).map(Realm::getAllUsers).map(Stream::of).orElseGet(Stream::empty).flatMap(Collection::stream);
        List simplerUsers = usersStream.filter(user -> !CDORepositoryUtil.isSpecialUser(user.getId())).map(UserUtil::mapToSimpleUser).collect(Collectors.toList());
        users.addAll(simplerUsers);
        return users;
    }

    @Override
    public IStatus createUser(RepositoryData repositoryData, NewUser newUser) {
        IStatus status;
        block6: {
            status = Status.OK_STATUS;
            String repositoryName = repositoryData.getRepositoryName();
            CDOTransactionHelper transactionHelper = new CDOTransactionHelper();
            CDOTransaction cdoTransaction = transactionHelper.getOrCreateTransaction(repositoryName);
            try {
                try {
                    status = UserUtil.createUser(newUser, cdoTransaction, repositoryName);
                    if (status.isOK()) {
                        cdoTransaction.setCommitComment("[User Profile] Create user " + newUser.getId());
                        cdoTransaction.commit();
                        break block6;
                    }
                    cdoTransaction.rollback();
                }
                catch (CommitException e) {
                    status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", "Something unexpected happened while committing the transaction.", (Throwable)e);
                    cdoTransaction.rollback();
                    transactionHelper.disposeTransaction();
                }
            }
            finally {
                transactionHelper.disposeTransaction();
            }
        }
        return status;
    }

    @Override
    public IStatus deleteUser(RepositoryData repositoryData, String username) {
        IStatus status = Status.OK_STATUS;
        CDOTransactionHelper transactionHelper = new CDOTransactionHelper();
        CDOTransaction transaction = transactionHelper.getOrCreateTransaction(repositoryData.getRepositoryName());
        try {
            try {
                Optional<User> optionalUser = UserUtil.deleteUser(transaction, username);
                transaction.setCommitComment("[User Profile] Delete user " + username);
                transaction.commit();
                if (!optionalUser.isPresent()) {
                    status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("The user %1$s was not present.", username));
                }
            }
            catch (CommitException e) {
                status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("An error occurred during the commit. The user %1$s has not been deleted.", username), (Throwable)e);
                transactionHelper.disposeTransaction();
            }
        }
        finally {
            transactionHelper.disposeTransaction();
        }
        return status;
    }

    @Override
    public IStatus postSharedModelingProjectCreation(NewSharedModelingProject project) {
        IStatus status = Status.OK_STATUS;
        String repositoryName = project.getRepositoryName();
        String projectName = project.getProjectName();
        CDOTransactionHelper helper = new CDOTransactionHelper();
        CDOTransaction transaction = helper.getOrCreateTransaction(repositoryName);
        try {
            try {
                Realm realm = CommonUtil.getRealmFromTransaction(transaction);
                Role projectWriter = realm.addRole(projectName);
                projectWriter.getPermissions().add((Object)SF.createResourcePermission("/" + projectName, Access.WRITE));
                projectWriter.getPermissions().add((Object)SF.createResourcePermission("/" + projectName + "/.*", Access.WRITE));
                transaction.setCommitComment("[User Profile] Set permissions for project " + projectName);
                transaction.commit();
            }
            catch (CommitException e) {
                status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", ROLES_CREATION_ERROR_MESSAGE, (Throwable)e);
                transaction.rollback();
                helper.disposeTransaction();
            }
        }
        finally {
            helper.disposeTransaction();
        }
        return status;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String validateData(Map<String, Object> data) {
        Object administrators = data.get("administrators");
        String diagnostic = administrators == null ? "The list of administrators is empty." : (!(administrators instanceof Collection) ? "Administrators must be a collection of administrators." : this.validateAdministratorsList((Collection)administrators));
        return diagnostic;
    }

    private String validateAdministratorsList(Collection<?> administrators) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (administrators.isEmpty()) {
            diagnostic = "The list of administrators is empty.";
        } else {
            boolean hasInvalidAdministrators = administrators.stream().anyMatch(obj -> !(obj instanceof Map));
            if (hasInvalidAdministrators) {
                diagnostic = "At least one administrator is invalid.";
            } else {
                Set diagnosticSet = administrators.stream().map(Map.class::cast).map(this::validateAdministrator).filter(diag -> !"NO_ISSUE_DIAGNOSTIC".equals(diag)).collect(Collectors.toSet());
                if (!diagnosticSet.isEmpty()) {
                    diagnostic = diagnosticSet.stream().collect(Collectors.joining(System.lineSeparator()));
                }
            }
        }
        return diagnostic;
    }

    protected String validateAdministrator(Map<String, Object> administrator) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        Object login = administrator.get("login");
        Object password = administrator.get("password");
        if (!(login instanceof String)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "At least one administrator login is invalid.");
        } else if (StringUtil.isEmpty(login.toString())) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "At least one administrator login is empty.");
        }
        if (!(password instanceof String)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "At least one administrator password is invalid.");
        } else if (StringUtil.isEmpty(password.toString())) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "At least one administrator password is empty.");
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    @Override
    public String validateNewUser(NewUser newUser, String repositoryName) {
        boolean hasInvalidPermissions;
        List<String> permissions;
        String diag;
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        if (this.shouldStorePassword() && !"NO_ISSUE_DIAGNOSTIC".equals(diag = UserUtil.validateUserPassword(newUser.getPassword()))) {
            AdminServletValidator.completeDiagnostic(detectedIssues, diag);
        }
        if ((permissions = newUser.getPermissions()) != null && !permissions.isEmpty() && (hasInvalidPermissions = permissions.stream().anyMatch(StringUtil::isEmpty))) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "Some permissions are null or empty.");
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    protected boolean shouldStorePassword() {
        return true;
    }
}

