/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.ldap;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AbstractRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.LDAPUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LdapAuthenticationRepositoryManager
extends AbstractRepositoryManager
implements IRepositoryManager {
    private static final String KEY = "LDAP";
    private static final String DESCRIPTION_XML_TAG_ATTRIBUTE = "description";
    private static final String TYPE_XML_TAG_ATTRIBUTE = "type";
    private static final String AUTHENTICATOR_XML_TAG = "authenticator";
    private static final String LDAP_CONFIG_PROPERTIES_FILE = "ldap.properties";
    private static final String USERS_CANNOT_BE_CREATED = "User creation is not supported, repository %1$s does not manage users but only authentication with LDAP. Contact your LDAP administrator if you need to add a new user.";

    @Override
    public void manage(Document document, Element parentElement, RepositoryData repositoryData) {
        String propertiesFilePath = this.createPropertiesFile(repositoryData);
        Element element = document.createElement(AUTHENTICATOR_XML_TAG);
        element.setAttribute(TYPE_XML_TAG_ATTRIBUTE, "special_user_ldap");
        element.setAttribute(DESCRIPTION_XML_TAG_ATTRIBUTE, propertiesFilePath);
        parentElement.appendChild(element);
    }

    private String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        Map<String, Object> authenticationData = repositoryData.getAuthenticationData();
        String userProfileConfigurationFilePath = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + LDAP_CONFIG_PROPERTIES_FILE;
        Map<String, String> ldapProperties = LDAPUtil.addLDAPPropertiesToMap(authenticationData, true);
        try {
            CommonUtil.createProperiesFileFromMap(userProfileConfigurationFilePath, ldapProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The LDAP configuration properties file (%1$s) has not been created.", userProfileConfigurationFilePath), (Throwable)e);
        }
        return userProfileConfigurationFilePath;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String validateData(Map<String, Object> data) {
        return LDAPUtil.validateLDAPAuthenticationData(data);
    }

    @Override
    public String validateNewUser(NewUser newUser, String repositoryName) {
        return String.format(USERS_CANNOT_BE_CREATED, repositoryName);
    }
}

