/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.ldap;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.LDAPUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.UserManagerAuthenticationRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class LdapUserManagerAutenticationRepositoryManager
extends UserManagerAuthenticationRepositoryManager
implements IRepositoryManager {
    private static final String KEY = "LDAP_FILE";
    private static final String USERS_PROPERTIES_CONFIG_PROPERTIES_FILE = "users.properties";

    @Override
    protected String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        Map<String, Object> authenticationData = repositoryData.getAuthenticationData();
        String userManagerConfigurationFilePath = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + "usermanager-config.properties";
        String userPropertiesFile = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + USERS_PROPERTIES_CONFIG_PROPERTIES_FILE;
        try {
            Map<String, String> usersProperties = CDORepositoryUtil.convertCredentialsToProperties((ArrayList)authenticationData.get("users"));
            CommonUtil.createProperiesFileFromMap(userPropertiesFile, usersProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The users properties file (%1$s) has not been created", USERS_PROPERTIES_CONFIG_PROPERTIES_FILE), (Throwable)e);
        }
        LinkedHashMap<String, String> usermanagerProperties = new LinkedHashMap<String, String>();
        usermanagerProperties.put("users.file.path", userPropertiesFile);
        usermanagerProperties.putAll(LDAPUtil.addLDAPPropertiesToMap(authenticationData, false));
        try {
            CommonUtil.createProperiesFileFromMap(userManagerConfigurationFilePath, usermanagerProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The users manager properties file (%1$s) has not been created", USERS_PROPERTIES_CONFIG_PROPERTIES_FILE), (Throwable)e);
        }
        return userManagerConfigurationFilePath;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String validateData(Map<String, Object> data) {
        String validatedData;
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        String validatedLDAPAuthenticationData = LDAPUtil.validateLDAPAuthenticationData(data);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validatedLDAPAuthenticationData)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, validatedLDAPAuthenticationData);
        }
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validatedData = super.validateData(data))) {
            AdminServletValidator.completeDiagnostic(detectedIssues, validatedData);
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    @Override
    protected String validateUser(Map<String, Object> user) {
        String detectedIssues = "NO_ISSUE_DIAGNOSTIC";
        Object login = user.get("login");
        if (!(login instanceof String)) {
            detectedIssues = "At least one user login is invalid.";
        } else if (StringUtil.isEmpty(login.toString())) {
            detectedIssues = "At least one user login is empty.";
        }
        return detectedIssues;
    }

    @Override
    public String validateNewUser(NewUser newUser, String repositoryName) {
        return "NO_ISSUE_DIAGNOSTIC";
    }
}

