/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.ldap;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.LDAPUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.UserProfileRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class LdapUserProfileRepositoryManager
extends UserProfileRepositoryManager
implements IRepositoryManager {
    private static final String KEY = "LDAP_USERPROFILE";

    @Override
    protected String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        Map<String, Object> authenticationData = repositoryData.getAuthenticationData();
        String userProfileConfigurationFilePath = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + "userprofile-config.properties";
        String administratorsPropertiesFile = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + "administrator.properties";
        try {
            Map<String, String> adminProperties = CDORepositoryUtil.convertCredentialsToProperties((ArrayList)authenticationData.get("administrators"));
            CommonUtil.createProperiesFileFromMap(administratorsPropertiesFile, adminProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The administrator properties file (%1$s) has not been created", administratorsPropertiesFile), (Throwable)e);
        }
        LinkedHashMap<String, String> userProfileProperties = new LinkedHashMap<String, String>();
        userProfileProperties.put("realm.users.path", "users.userprofile");
        userProfileProperties.put("administrators.file.path", administratorsPropertiesFile);
        userProfileProperties.putAll(LDAPUtil.addLDAPPropertiesToMap(authenticationData, false));
        try {
            CommonUtil.createProperiesFileFromMap(userProfileConfigurationFilePath, userProfileProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The user profile configuration properties file (%1$s) has not been created", userProfileConfigurationFilePath), (Throwable)e);
        }
        return userProfileConfigurationFilePath;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String validateData(Map<String, Object> data) {
        String validatedAdministratorsData;
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        String validatedLDAPAuthenticationData = LDAPUtil.validateLDAPAuthenticationData(data);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validatedLDAPAuthenticationData)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, validatedLDAPAuthenticationData);
        }
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validatedAdministratorsData = super.validateData(data))) {
            AdminServletValidator.completeDiagnostic(detectedIssues, validatedAdministratorsData);
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    @Override
    protected String validateAdministrator(Map<String, Object> administrator) {
        String detectedIssues = "NO_ISSUE_DIAGNOSTIC";
        Object login = administrator.get("login");
        if (!(login instanceof String)) {
            detectedIssues = "At least one administrator login is invalid.";
        } else if (StringUtil.isEmpty(login.toString())) {
            detectedIssues = "At least one administrator login is empty.";
        }
        return detectedIssues;
    }

    @Override
    protected boolean shouldStorePassword() {
        return false;
    }
}

