/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository;

import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.AdminRepositoryConfigurator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractRepositoryConfigurator
extends RepositoryConfigurator {
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String REPOSITORY_TAG_NAME = "repository";
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REPOSITORY, AdminRepositoryConfigurator.class);
    private static final String START_REPOSITORY_ERROR = "The repository %s in %s could not to be started";

    public AbstractRepositoryConfigurator(IManagedContainer container) {
        super(container);
    }

    public IRepository[] getRepositories(File configFile) throws CoreException, SAXException {
        Document document;
        ArrayList<IRepository> repositories = new ArrayList<IRepository>();
        try {
            document = this.getDocument(configFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new SAXException(e);
        }
        NodeList elements = document.getElementsByTagName(REPOSITORY_TAG_NAME);
        int i = 0;
        while (i < elements.getLength()) {
            Element repositoryConfig = (Element)elements.item(i);
            IRepository repository = this.getRepository(repositoryConfig);
            repositories.add(repository);
            ++i;
        }
        return repositories.toArray(new IRepository[repositories.size()]);
    }

    protected IStatus configure(File configFile, String repositoryName) throws CoreException, ParserConfigurationException, SAXException, IOException {
        IRepository configure;
        IStatus status = Status.OK_STATUS;
        if (TRACER.isEnabled()) {
            TRACER.trace("Configuring CDO server from " + configFile.getAbsolutePath());
        }
        if ((configure = this.configure(this.getDocument(configFile), repositoryName)) == null) {
            status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format(START_REPOSITORY_ERROR, repositoryName, configFile.toString()));
        }
        return status;
    }

    protected IRepository configure(Document document, String repositoryName) throws CoreException {
        NodeList elements = document.getElementsByTagName(REPOSITORY_TAG_NAME);
        int i = 0;
        Element repositoryElement = null;
        while (repositoryElement == null && i < elements.getLength()) {
            Element repositoryConfig = (Element)elements.item(i);
            if (repositoryName.equals(repositoryConfig.getAttribute(NAME_ATTRIBUTE))) {
                repositoryElement = repositoryConfig;
            }
            ++i;
        }
        IRepository repository = null;
        if (repositoryElement != null) {
            repository = this.getRepository(repositoryElement);
            if (this.getContainer() != null) {
                CDOServerUtil.addRepository((IManagedContainer)OM.Activator.getContainer(), (IRepository)repository);
            }
        }
        return repository;
    }
}

