/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository;

import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.AbstractRepositoryConfigurator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AdminRepositoryConfigurator
extends AbstractRepositoryConfigurator {
    public AdminRepositoryConfigurator(IManagedContainer container) {
        super(container);
    }

    public List<String> getRepositoryNamesFromConfigurationFile(File configFile) {
        if (configFile == null || !configFile.exists()) {
            OM.LOG.info(String.format("The configuration file %1$s has not been found.", configFile.getName()));
            return Collections.emptyList();
        }
        ArrayList<String> repositoryNames = new ArrayList<String>();
        try {
            Document document = this.getDocument(configFile);
            NodeList elements = document.getElementsByTagName("repository");
            int i = 0;
            while (i < elements.getLength()) {
                Element element = (Element)elements.item(i);
                repositoryNames.add(element.getAttribute("name"));
                ++i;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            OM.LOG.error(String.format("An error occurred during the parsing of the %1$s configuration file", configFile.getName()), (Throwable)e);
        }
        return repositoryNames;
    }

    public IRepository createRepositoryFromConfigurationFile(File repositoryFile, String repositoryName) {
        IRepository repository = null;
        try {
            NodeList elements = this.getDocument(repositoryFile).getElementsByTagName("repository");
            int i = 0;
            while (i < elements.getLength()) {
                Element element = (Element)elements.item(i);
                if (element.getAttribute("name").equals(repositoryName)) {
                    repository = this.getRepository(element);
                    break;
                }
                ++i;
            }
        }
        catch (IOException | ParserConfigurationException | CoreException | SAXException e) {
            OM.LOG.error(String.format("An error occurred during the parsing of the %1$s configuration file", repositoryFile.getName()), e);
        }
        return repository;
    }
}

