/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository;

import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.WebserviceJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.server.CDOServerExporter;
import org.eclipse.emf.cdo.server.IRepository;

public class ExportJob
extends WebserviceJob {
    private File destinationDirectory;
    private IRepository repository;
    private boolean toEncrypt;
    private String fileName;
    private String archivePassword;

    public ExportJob(File destinationDirectory, String fileName, IRepository repository, boolean toEncrypt, String archivePassword) {
        super("Export Job");
        this.destinationDirectory = destinationDirectory;
        this.fileName = fileName;
        this.repository = repository;
        this.toEncrypt = toEncrypt;
        this.archivePassword = archivePassword;
        if (this.archivePassword == null) {
            this.archivePassword = "";
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        CDOServerExporter.XML xml = new CDOServerExporter.XML(this.repository);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            xml.exportRepository((OutputStream)baos);
            if (this.toEncrypt) {
                this.writeInEncryptedZipFile(baos.toByteArray());
            } else {
                this.writeInFile(baos.toByteArray());
            }
        }
        catch (Exception e) {
            return this.reportError(e);
        }
        return Status.OK_STATUS;
    }

    private void writeInEncryptedZipFile(byte[] byteArray) throws ZipException, IOException {
        File destinationFile = this.createDestinationFile("zip", false);
        ZipFile zipFile = new ZipFile(destinationFile);
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setFileNameInZip(String.valueOf(this.fileName) + ".xml");
        zipParameters.setSourceExternalStream(true);
        zipParameters.setCompressionMethod(8);
        zipParameters.setCompressionLevel(9);
        zipParameters.setEncryptFiles(true);
        zipParameters.setEncryptionMethod(99);
        zipParameters.setAesKeyStrength(3);
        zipParameters.setPassword(this.archivePassword);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);){
            zipFile.addStream((InputStream)byteArrayInputStream, zipParameters);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeInFile(byte[] byteArray) throws IOException {
        File destinationFile = this.createDestinationFile("xml", true);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream fos = new FileOutputStream(destinationFile);){
            fos.write(byteArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private File createDestinationFile(String fileExtension, boolean createIfNotExists) throws IOException {
        File file = Paths.get(this.destinationDirectory.getAbsolutePath(), String.valueOf(this.fileName) + "." + fileExtension).toFile();
        if (!file.exists() && createIfNotExists) {
            file.createNewFile();
        }
        return file;
    }

    private IStatus reportError(Exception e) {
        OM.LOG.error(String.format("The export of the repository %1$s failed", this.repository.getName()), (Throwable)e);
        return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("The export of the repository %1$s failed", this.repository.getName()), (Throwable)e);
    }

    public boolean belongsTo(Object family) {
        return "fr.obeo.dsl.viewpoint.collab.server.admin.webserviceJob".equals(family);
    }
}

