/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository;

import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.WebserviceJob;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.server.CDOServerImporter;
import org.eclipse.emf.cdo.server.IRepository;

public class ImportJob
extends WebserviceJob {
    private IRepository repository;
    private byte[] data;

    public ImportJob(IRepository iRepository, byte[] byteArray) {
        super("Import Job");
        this.repository = iRepository;
        this.data = byteArray;
    }

    protected IStatus run(IProgressMonitor monitor) {
        boolean isRepositoryStarted = CDORepositoryUtil.isStarted(this.repository.getName());
        if (isRepositoryStarted) {
            CDORepositoryUtil.stopRepository(this.repository.getName());
        }
        boolean activeBeforeImport = this.repository.isActive();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(this.data);){
                new CDOServerImporter.XML(this.repository).importRepository((InputStream)bais);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            OM.LOG.error(String.format("The import to the repository %1$s failed", this.repository.getName()), (Throwable)e);
            return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("The import of data into the repository %1$s failed", this.repository.getName()), (Throwable)e);
        }
        if (this.repository.isActive() && !activeBeforeImport) {
            this.repository.deactivate();
        }
        IStatus result = Status.OK_STATUS;
        if (isRepositoryStarted) {
            result = CDORepositoryUtil.startRepository(this.repository.getName());
        }
        return result;
    }
}

