/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.security;

import fr.obeo.dsl.viewpoint.collab.common.internal.security.SecureStorageService;
import fr.obeo.dsl.viewpoint.collab.common.internal.security.TokenManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.TokenCredential;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.RolePrincipal;
import org.eclipse.jetty.security.UserPrincipal;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.util.security.Credential;

public class SecureStorageLoginService
extends AbstractLoginService {
    private static final String SECRET_FILENAME = "secret.txt";
    private static final String ADMIN_ROLE = "admin";
    private UserStore userStore;
    private int httpPort;
    private String configPath;
    private TokenManager tokenManager;

    public SecureStorageLoginService(String configPath, int httpPort) {
        this(configPath, new TokenManager());
        this.httpPort = httpPort;
    }

    public SecureStorageLoginService(String configPath, TokenManager tokenManager) {
        this.configPath = Objects.requireNonNull(configPath);
        this.tokenManager = Objects.requireNonNull(tokenManager);
    }

    public List<RolePrincipal> loadRoleInfo(UserPrincipal user) {
        return this.userStore.getRolePrincipals(user.getName());
    }

    public UserPrincipal loadUserInfo(String username) {
        try {
            this.userStore = new UserStore();
            SecureStorageService storageService = new SecureStorageService(null, this.tokenManager, this.httpPort);
            this.loadUserStore(storageService);
            storageService.close();
        }
        catch (StorageException e) {
            OM.LOG.error((Throwable)e);
        }
        return this.userStore.getUserPrincipal(username);
    }

    protected void doStart() throws Exception {
        super.doStart();
        SecureStorageService storageService = new SecureStorageService(null, this.tokenManager, this.httpPort);
        if (!storageService.isInitialized()) {
            Optional optionalAdminToken = storageService.generateInitialAdminToken();
            optionalAdminToken.ifPresent(this::generateClearSecretToken);
        }
    }

    private void loadUserStore(SecureStorageService storageService) throws StorageException {
        List credentialsFromSecureStorage = storageService.loadCredentialsFromSecureStorage();
        credentialsFromSecureStorage.forEach(authInfo -> {
            Collection<char[]> tokenValues = authInfo.getTokens().values();
            TokenCredential credential = new TokenCredential(tokenValues, this.tokenManager);
            this.userStore.addUser(authInfo.getUserID(), (Credential)credential, new String[]{ADMIN_ROLE});
        });
    }

    private void generateClearSecretToken(char[] token) {
        File file = new File(this.configPath);
        if (file.exists() && file.isDirectory()) {
            Path path = Paths.get(file.getPath(), SECRET_FILENAME);
            try {
                Files.deleteIfExists(path);
                File secretFile = Files.createFile(path, new FileAttribute[0]).toFile();
                try {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(secretFile);){
                        fileOutputStream.write(String.valueOf(token).getBytes());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    OM.LOG.error((Throwable)e);
                }
            }
            catch (IOException e) {
                OM.LOG.error((Throwable)e);
            }
        } else {
            OM.LOG.error(String.format("Impossible to create the %1$s file in the specified configuration file folder: %2$s", SECRET_FILENAME, this.configPath));
        }
    }

    protected void doStop() throws Exception {
        this.userStore = null;
        super.doStop();
    }
}

