/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.security;

import fr.obeo.dsl.viewpoint.collab.common.internal.security.TokenManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jetty.util.security.Credential;

public class TokenCredential
extends Credential {
    private static final long serialVersionUID = 8947261422880224152L;
    private List<char[]> tokens;
    private TokenManager tokenManager;

    public TokenCredential(Collection<char[]> tokens, TokenManager tokenManager) {
        this.tokens = new ArrayList<char[]>(tokens);
        this.tokenManager = Objects.requireNonNull(tokenManager);
    }

    public boolean check(Object credentials) {
        if (credentials instanceof String) {
            for (char[] token : this.tokens) {
                Optional optionalEncrypted = this.tokenManager.encrypt(((String)credentials).toCharArray());
                if (!optionalEncrypted.isPresent() || !Arrays.equals(token, (char[])optionalEncrypted.get())) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.tokens.hashCode();
    }

    public boolean equals(Object obj) {
        return this.check(obj);
    }
}

