/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.security.ChallengeNegotiator;
import org.eclipse.net4j.util.security.IRandomizer;
import org.eclipse.net4j.util.security.IUserManager;

public class ChallengeNegotiatorConfigurer
implements IElementProcessor {
    public Object process(IManagedContainer container, String productGroup, String factoryType, String description, Object element) {
        if (element instanceof ChallengeNegotiator) {
            ChallengeNegotiator negotiator = (ChallengeNegotiator)element;
            if (negotiator.getRandomizer() == null) {
                IRandomizer randomizer = this.getRandomizer(container, description);
                negotiator.setRandomizer(randomizer);
            }
            if (negotiator.getUserManager() == null) {
                IUserManager userManager = this.getUserManager(container, description);
                negotiator.setUserManager(userManager);
            }
        }
        return element;
    }

    protected IRandomizer getRandomizer(IManagedContainer container, String description) {
        String productGroup = "org.eclipse.net4j.randomizers";
        String type = this.getRandomizerType(description);
        return (IRandomizer)container.getElement(productGroup, type, this.getRandomizerDescription(description));
    }

    protected String getRandomizerType(String description) {
        return "default";
    }

    protected String getRandomizerDescription(String description) {
        return null;
    }

    protected IUserManager getUserManager(IManagedContainer container, String description) {
        String productGroup = "org.eclipse.net4j.userManagers";
        String type = this.getUserManagerType(description);
        return (IUserManager)container.getElement(productGroup, type, this.getUserManagerDescription(description));
    }

    protected String getUserManagerType(String description) {
        return "file";
    }

    protected String getUserManagerDescription(String description) {
        return description;
    }
}

