/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.jetty.customizer.error;

import com.google.gson.JsonSyntaxException;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ErrorResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class DefaultErrorHandler
extends ErrorHandler {
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ErrorResponse resp = null;
        Class exceptionType = (Class)request.getAttribute("javax.servlet.error.exception_type");
        if (exceptionType != null) {
            if (SecurityException.class.isAssignableFrom(exceptionType)) {
                resp = ResponseFactory.createErrorResponse((String)"An error occurred during the authentication.", (int)401, (String)request.getAttribute("javax.servlet.error.message").toString());
            } else if (InvalidURIException.class.isAssignableFrom(exceptionType)) {
                resp = ResponseFactory.createBadRequestErrorResponse((String)"A requested URI is invalid.", (String)request.getAttribute("javax.servlet.error.message").toString());
            } else if (JsonSyntaxException.class.isAssignableFrom(exceptionType)) {
                resp = ResponseFactory.createBadRequestErrorResponse((String)"An error occurred during the deserialization of the json body.", (String)"The json body is not well formed.");
            } else if (ServletException.class.isAssignableFrom(exceptionType)) {
                Optional<Object> optionalError = Optional.ofNullable(request.getAttribute("javax.servlet.error.message"));
                optionalError.map(Object::toString).filter(message -> message.equals("javax.servlet.ServletException: Not a multipart request!"));
                resp = optionalError.isPresent() ? ResponseFactory.createBadRequestErrorResponse((String)"No file has been provided.", (String)optionalError.get().toString()) : ResponseFactory.createInternalServerErrorResponse((String)"An error occurred.", (String)request.getAttribute("javax.servlet.error.message").toString());
            }
            OM.LOG.error(request.getAttribute("javax.servlet.error.message").toString());
            OM.LOG.error(request.getAttribute("javax.servlet.error.exception").toString());
            response.setStatus(resp.getStatus());
            JsonBodyWriter.write((HttpServletResponse)response, resp.getClass(), (Object)resp);
        }
        super.handle(target, baseRequest, request, response);
    }
}

