@echo off
REM
REM Team for Capella Repository Maintenance
REM
REM Communication with server using https
REM   - switch httpPort to server https port (default: 8443): -httpPort 8443
REM   - trusted certificate: 
REM      - simply switch the httpsConnection parameter to true: -httpsConnection true
REM   - self-signed certificate: 
REM      - switch the httpsConnection parameter to true: -httpsConnection true
REM      - complete  -vmargs with -Dfr.obeo.dsl.viewpoint.collab.https.jetty.ssl.context.trustall=true
REM      - or install your certificate in the JVM
REM
REM Http credentials can be passed through several ways:
REM   - (default) registered in the secure storage, see Scheduler jobs and/or toolsCredentials.bat
REM   - as program arguments -httpLogin admin and -httpPassword token_value
REM   - in a properties file referenced from program arguments with -httpCredentials httpCredentials.properties
@echo on

cd ../capella

REM Communication with server using http
SMWc.exe ^
--launcher.suppressErrors ^
-nosplash -console -consoleLog ^
-data maintenance-workspace ^
-application com.thalesgroup.mde.melody.collab.maintenance ^
-repositoryCredentials ../tools/repositoryCredentials.properties ^
-httpHost localhost ^
-httpPort 8080 ^
-httpsConnection false ^
%* ^
-vmargs -Xms1000m -Xmx3000m -Xss4m ^
-Dorg.eclipse.net4j.util.om.trace.disable=true ^
-Dosgi.requiredJavaVersion=11 ^
-Dosgi.dataAreaRequiresExplicitInit=true ^
-Dlogback.configurationFile=configuration/logback.xml ^
-Dpde.jreProfile=JavaSE-17

@echo off

REM Communication with server using telnet (deprecated)
REM SMWc.exe ^
REM --launcher.suppressErrors ^
REM -nosplash -console -consoleLog ^
REM -data maintenance-workspace ^
REM -application com.thalesgroup.mde.melody.collab.maintenance ^
REM -repositoryCredentials ../tools/repositoryCredentials.properties ^
REM -consolePort 12036 ^
REM %* ^
REM -vmargs -Xms1000m -Xmx3000m -Xss4m ^
REM -Dorg.eclipse.net4j.util.om.trace.disable=true ^
REM -Dosgi.requiredJavaVersion=11 ^
REM -Dosgi.dataAreaRequiresExplicitInit=true ^
REM -Dlogback.configurationFile=configuration/logback.xml ^
REM -Dpde.jreProfile=JavaSE-17