@echo off
echo Team for Capella 6.1.0 - Jenkins customization as Scheduler
echo ---
SET JENKINS_URL=http://localhost:8036/

REM Those variables might be automatically retrieved by the CLI
REM  and avoid to define LOGIN/PASSWORD variables to use with -auth %LOGIN%:%PASSWORD% on each call of the CLI.
SET JENKINS_USER_ID=admin
SET JENKINS_API_TOKEN=abc1234ffe4a
REM As documented in https://www.jenkins.io/doc/book/managing/cli/,
REM you can get your API token from /me/configure page of your Jenkins.

REM Two list of plugins available by default:
REM  - the first one allows to force the installation of the plugins tested 
REM    during acceptance phase of Team for Capella with Jenkins LTS 2.375.3
SET PLUGINS_LIST_FILE=requiredPlugins_Jenkins_LTS_2.375.3.txt

REM  - the second list allows to use shortnames of the same plugins
REM    to let Jenkins take the latest version available in its update center 
REM SET PLUGINS_LIST_FILE=requiredPlugins_Jenkins_ShortNames_UpdateCenter.txt

REM Download Jenkins CLI from Jenkins itself
echo Download Jenkins CLI from %JENKINS_URL%
curl -o jenkins-cli.jar "%JENKINS_URL%/jnlpJars/jenkins-cli.jar"
echo ---
echo Install plugins required for Team for Capella 6.1.0 on Jenkins (%JENKINS_URL%)
setlocal enabledelayedexpansion
FOR /f "eol=#" %%A in (%PLUGINS_LIST_FILE%) do (
    SET plugin=%%A
    java -jar jenkins-cli.jar -s %JENKINS_URL% install-plugin !plugin!
)
echo End of required plugin installation for Team for Capella 6.1.0 Scheduler jobs on Jenkins (%JENKINS_URL%)
echo ---
echo Copy Team for Capella Scheduler jobs on Jenkins (%JENKINS_URL%)
FOR /D /r %%G in ("./jobs/*") DO (
	echo Import job %%~nxG to Jenkins
	java -jar jenkins-cli.jar -s %JENKINS_URL% -webSocket create-job "%%~nxG" < "./jobs/%%~nxG/config.xml"
)
echo End of Team for Capella Scheduler jobs copy 
echo ---
echo Sort jobs in views by categories on Jenkins (%JENKINS_URL%)
FOR /D /r %%G in ("./views/*") DO (
	echo Create view %%~nxG
	java -jar jenkins-cli.jar -s %JENKINS_URL% -webSocket create-view "%%~nxG" < "./views/%%~nxG/config.xml"
)
echo End of jobs and view organization
echo ---
echo End of Team for Capella 6.1.0 - Jenkins customization as Scheduler (%JENKINS_URL%))
echo ---
echo Retrieve documentation in the Capella's embedded help:
echo   - Open the help from the menu Help / Help Contents
echo   - Navigate to Team for Capella Guide / System Administrator Guide / Jenkins Installation
echo ---
echo The installed jobs executes Team for Capella applications:
echo   - Therefore Jenkins requires a global environment variable referencing the location of your team for Capella installation
echo     - Go to Manage Jenkins / Configure System and scroll down to the Global properties section.
echo     - Check Environment variables and add a new one named TEAMFORCAPELLA_APP_HOME
echo     - Set the value to the absolute path of your Team for Capella installation folder
echo       (it is the top folder that contains the subfolders "capella", "server", "tools"...).
echo   - We recommend to change the number of executors to 5:
echo     - By default Jenkins provides two build executors. This means that two applications can run at the same time. 
echo     - However, the CDO server and the License server are application that keeps running. Therefore, they will block any other application. 
echo     - For this, click on the "Build Executor Status" (Bottom left on the Jenkins Dashboard).
echo     - Then on the entry presenting the computer, click on the Configure button. 
echo     - On this executors configuration page, set the number of executors to 5.
echo   - Change the Markup Formatter to display the jobs descriptions as HTML and not as plain text.
echo     - Go to Manage Jenkins / Configure Global Security and scroll down to the Markup Formatter section.
echo     - Change the value to Safe HTML.
echo   - See additional possible settings in Team for Capella Guide / System Administrator Guide / Jenkins installation / Miscellaneous settings.
echo ---
echo Restart Jenkins at the end of this configuration phase
echo ---