/*******************************************************************************
 * Copyright (c) 2022 THALES GLOBAL SERVICES. All rights reserved.
 *
 * Contributors: Obeo - initial API and implementation
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.internal.security;

/**
 * Secure Storage nodes keys.
 * 
 * @author fbarbin
 *
 */
public final class SecureStorageKeys {

    /**
     * Key to store "per Repository" credentials used by the tools applications (importer, exporter, maintenance) in
     * Eclipse Secure Storage.
     */
    public static final String COLLAB_TOOLS = "fr.obeo.dsl.viewpoint.collab.credentials.tools.net4j"; //$NON-NLS-1$

    /**
     * Key to store "per Server" credentials for the HTTP requests to RestAdmin server in Eclipse Secure Storage
     * (command application, but also HTTP request done by other tools applications).
     */
    public static final String HTTP_CREDENTIALS = "fr.obeo.dsl.viewpoint.collab.credentials.tools.http"; //$NON-NLS-1$

    /**
     * Key to store realm of the RestAdmin server (Jetty basic auth)) in Eclipse Secure Storage.
     */
    public static final String SERVER_REST_ADMIN = "fr.obeo.dsl.viewpoint.collab.credentials.server.admin"; //$NON-NLS-1$ s

    /**
     * Key to store "per Repository" credentials used by the standard UI (equivalent of the "Remember" me check box in
     * wizards). in Eclipse Secure Storage.
     */
    public static final String USER_INTERFACE = "fr.obeo.dsl.viewpoint.collab.credentials.user"; //$NON-NLS-1$

    private SecureStorageKeys() {
        // prevent instantiation
    }
}
