/*******************************************************************************
 * Copyright (c) 2006, 2021 THALES GLOBAL SERVICES. All rights reserved. 
 *******************************************************************************/

package fr.obeo.dsl.viewpoint.collab.common.user.protocol;

/**
 * Protocol constants used for remote administration task on collab server.
 * 
 * @author <a href="mailto:laurent.fasani@obeo.fr">Laurent Fasani</a>
 */
public interface ICollabProtocolConstants {

    /**
     * Name of the protocol for collab specific requests.
     */
    String PROTOCOL_NAME = "COLLAB"; //$NON-NLS-1$

    /**
     * Name of the protocol for OpenID Connect specific requests.
     */
    String OIDC_PROTOCOL_NAME = "openidconnect"; //$NON-NLS-1$

    //
    // User Management
    //

    /**
     * Signal ID used to know if the password needs to be stored.
     */
    short SIGNAL_ID_USERS_MANAGEMENT_IS_PASSWORD_TO_STORE = 201;

    /**
     * Signal ID used to get information about authentication based on OpenID Connect.
     */
    short SIGNAL_ID_GET_OPENID_AUTHENTIFICATION_INFO = 202;
}
