/*******************************************************************************
 * Copyright (c) 2021 THALES GLOBAL SERVICES.
 * All rights reserved.
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.internal.http.auth;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

import com.google.gson.Gson;

/**
 * POJO representing information to put in the response Cookie.
 * 
 * @author lfasani
 *
 */
public class AuthInformationCookie {

    /**
     * The name of the cookie used to store authentication information.
     */
    public static final String COOKIE_NAME = "fr.obeo.dsl.viewpoint.collab.openidconnectInformation"; //$NON-NLS-1$

    private String userid;

    private String userName;

    /**
     * Default constructor.
     * 
     * @param userid
     *            an id that identifies the connection of a user
     * @param userName
     *            the display name of the user
     */
    public AuthInformationCookie(String userid, String userName) {
        super();
        this.userid = userid;
        this.userName = userName;
    }

    public String getUserid() {
        return userid;
    }

    public String getUserName() {
        return userName;
    }

    /**
     * The cookie value needs to be formatted to escape some invalid characters.
     * 
     * @return the string to be used as cookie value for a http request
     */
    public String getCookieValue() {
        String json = new Gson().toJson(this);

        try {
            json = URLEncoder.encode(json, StandardCharsets.UTF_8.toString());
        } catch (UnsupportedEncodingException e) {
        }

        return json;
    }

    /**
     * The cookie value needs to be formatted to escape some invalid characters.
     * 
     * @param cookieValue
     *            the cookie value received
     * @return the string to be used as cookie value for a http request
     */
    public static AuthInformationCookie getAuthInformationCookieFromCookieValue(String cookieValue) {
        String json = ""; //$NON-NLS-1$
        try {
            json = URLDecoder.decode(cookieValue, StandardCharsets.UTF_8.toString());
        } catch (UnsupportedEncodingException e) {
        }
        AuthInformationCookie authInformationCookie = new Gson().fromJson(json, AuthInformationCookie.class);
        return authInformationCookie;
    }

}
